/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ClassDoc;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import org.aspectj.ajdoc.AdviceDoc;
import org.aspectj.ajdoc.AspectDoc;
import org.aspectj.ajdoc.IntroductionDoc;
import org.aspectj.ajdoc.OfClauseDoc;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.IntroducedSuperDec;
import org.aspectj.tools.ajdoc.AdviceDocImpl;
import org.aspectj.tools.ajdoc.ClassDocImpl;
import org.aspectj.tools.ajdoc.IntroducedSuperDocImpl;
import org.aspectj.tools.ajdoc.IntroductionDocImpl;
import org.aspectj.tools.ajdoc.OfClauseDocImpl;
import org.aspectj.tools.ajdoc.ProgramElementDocImpl;

public class AspectDocImpl
extends ClassDocImpl
implements AspectDoc {
    private final Collection advice;
    private final Collection introductions;
    private final OfClauseDoc ofClause;
    private final Collection dominators = new ArrayList();
    private final Collection dominatees = new ArrayList();

    public AspectDocImpl(ClassDoc containingClass, AspectDec aspectDec) {
        super(containingClass, aspectDec);
        this.introductions = this.createIntroductions();
        this.advice = this.createAdvice();
        this.ofClause = this.createOfClause();
    }

    public AdviceDocImpl docForDec(AdviceDec dec) {
        Iterator i = this.advice.iterator();
        while (i.hasNext()) {
            AdviceDocImpl ad = (AdviceDocImpl)i.next();
            if (ad.dec() != dec) continue;
            return ad;
        }
        return null;
    }

    public IntroducedSuperDocImpl introDocForDec(IntroducedSuperDec dec) {
        Iterator i = this.introductions.iterator();
        while (i.hasNext()) {
            ProgramElementDocImpl id = (ProgramElementDocImpl)i.next();
            if (id.dec() != dec) continue;
            return (IntroducedSuperDocImpl)id;
        }
        return null;
    }

    protected AspectDec aspectDec() {
        return (AspectDec)this.typeDec();
    }

    public AdviceDoc[] advice() {
        return this.advice.toArray(new AdviceDocImpl[this.advice.size()]);
    }

    public AspectDoc[] dominatees() {
        return this.dominatees.toArray(new AspectDoc[this.dominatees.size()]);
    }

    public AspectDoc[] dominators() {
        return this.dominators.toArray(new AspectDoc[this.dominators.size()]);
    }

    public IntroductionDoc[] introductions() {
        return this.introductions.toArray(new IntroductionDocImpl[this.introductions.size()]);
    }

    public OfClauseDoc ofClause() {
        return this.ofClause;
    }

    public boolean isAspect() {
        return true;
    }

    public boolean dominates(AspectDoc other) {
        if (!(other instanceof AspectDocImpl)) {
            return false;
        }
        return this.aspectDec().dominates(((AspectDocImpl)other).aspectDec());
    }

    public void addDominator(AspectDoc dominator) {
        this.dominators.add(dominator);
    }

    public void addDominatee(AspectDoc dominatee) {
        this.dominatees.add(dominatee);
    }

    private Collection createIntroductions() {
        Decs decs = this.aspectDec().getBody();
        if (decs.size() < 1) {
            return Collections.EMPTY_LIST;
        }
        HashSet<IntroductionDocImpl> list = new HashSet<IntroductionDocImpl>();
        Iterator i = decs.getList().iterator();
        while (i.hasNext()) {
            IntroductionDocImpl o = IntroductionDocImpl.getInstance(this, i.next());
            if (o == null) continue;
            list.add(o);
        }
        return list;
    }

    private Collection createAdvice() {
        ArrayList decs = this.aspectDec().getJpPlannerMakers();
        if (null != decs) {
            int QUIT = 2;
            int tries = 0;
            while (tries < 2) {
                try {
                    Iterator i = decs.iterator();
                    while (i.hasNext()) {
                        Object o = i.next();
                        if (o instanceof AdviceDec) continue;
                        i.remove();
                    }
                    tries = 2;
                }
                catch (UnsupportedOperationException o) {
                    if (0 != tries) {
                        tries = 2;
                    }
                    ArrayList list = new ArrayList();
                    list.addAll(decs);
                    decs = list;
                }
                ++tries;
            }
        }
        if (null == decs || decs.size() < 1) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<AdviceDocImpl> list = new ArrayList<AdviceDocImpl>();
        Iterator i = decs.iterator();
        while (i.hasNext()) {
            list.add(new AdviceDocImpl(this, (AdviceDec)i.next()));
        }
        return list;
    }

    private OfClauseDoc createOfClause() {
        return OfClauseDocImpl.getInstance(this.aspectDec().getPerClause());
    }
}

