/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.RootDoc;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.aspectj.compiler.base.AbstractCompilerPass;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.ast.CompilationUnit;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.World;
import org.aspectj.compiler.crosscuts.AspectJCompiler;
import org.aspectj.tools.ajdoc.AccessChecker;
import org.aspectj.tools.ajdoc.CannotMakeRootDocException;
import org.aspectj.tools.ajdoc.ClassDocImpl;
import org.aspectj.tools.ajdoc.ErrPrinter;
import org.aspectj.tools.ajdoc.PackageDocImpl;
import org.aspectj.tools.ajdoc.RootDocImpl;
import org.aspectj.tools.ajdoc.RootDocMaker;

public class AjdocCompiler
extends AspectJCompiler
implements RootDocMaker {
    protected final String programName;
    protected final ErrPrinter err;
    private Set pkgnames = new HashSet();
    private Set classnames = new HashSet();
    private Set files = new HashSet();
    protected final List srcfiles = new ArrayList();
    protected List srcSrcfilenames = new ArrayList();
    protected List pkgSrcfilenames = new ArrayList();
    protected List clsSrcfilenames = new ArrayList();
    protected final List sourcepaths = new ArrayList();
    protected AccessChecker filter;
    private static AjdocCompiler instance;
    protected final Map filesToClassnames;
    protected final Map filesToPkgnames;
    protected final Map filesToFilenames;

    public AjdocCompiler(ErrorHandler errorHandler, String programName) {
        super(errorHandler);
        this.sourcepaths.add(new File("."));
        instance = this;
        this.filesToClassnames = new HashMap();
        this.filesToPkgnames = new HashMap();
        this.filesToFilenames = new HashMap();
        this.getOptions().preprocess = true;
        this.getOptions().nocomments = true;
        this.programName = programName;
        this.err = new ErrPrinter(this.programName);
        errorHandler = this.err;
        this.err.setCompiler(this);
    }

    public AjdocCompiler(String programName) {
        this(null, programName);
    }

    public ErrPrinter err() {
        return this.err;
    }

    public RootDoc makeRootDoc(String sourcepath, String classpath, String bootclasspath, String extdirs, long flags, String encoding, String locale, String source, List filenamesAndPackages, List options, DocErrorReporter err, String programName, AccessChecker filter) throws CannotMakeRootDocException {
        if (null != filter && this.filter != filter) {
            this.filter = filter;
        }
        if (null == this.filter) {
            this.filter = AccessChecker.PROTECTED;
        }
        if (classpath != null) {
            this.getOptions().classpath = classpath;
        }
        if (bootclasspath != null) {
            this.getOptions().bootclasspath = bootclasspath;
        }
        if (extdirs != null) {
            this.getOptions().extdirs = extdirs;
        }
        this.resolveSourcePath(sourcepath);
        this.resolveFilesAndPackages(filenamesAndPackages);
        Collections.sort(this.pkgSrcfilenames);
        Collections.sort(this.clsSrcfilenames);
        Collections.sort(this.srcSrcfilenames);
        this.srcfiles.addAll(this.pkgSrcfilenames);
        this.srcfiles.addAll(this.clsSrcfilenames);
        this.srcfiles.addAll(this.srcSrcfilenames);
        this.err().notice("starting_internal_compile");
        Iterator i = options.iterator();
        while (i.hasNext()) {
            String[] opts = (String[])i.next();
            if (opts.length == 1) {
                if (!opts[0].equals("-verbose")) continue;
                this.getOptions().verbose = true;
                continue;
            }
            if (opts.length != 2) continue;
            if (opts[0].equals("-classpath")) {
                this.getOptions().classpath = opts[1];
                continue;
            }
            if (opts[1].equals("-bootclasspath")) {
                this.getOptions().bootclasspath = opts[1];
                continue;
            }
            if (!opts[1].equals("-extdirs")) continue;
            this.getOptions().extdirs = opts[1];
        }
        this.addPasses();
        this.internalCompile(this.srcfiles);
        World world = this.getWorld();
        Iterator i2 = world.getCompilationUnits().iterator();
        while (i2.hasNext()) {
            Decs decs = ((CompilationUnit)i2.next()).getDecs();
            int j = 0;
            int N = decs.size();
            while (j < N) {
                Dec dec = decs.get(j);
                if (dec instanceof TypeDec) {
                    this.classnames.add(((TypeDec)dec).getFullName());
                }
                ++j;
            }
        }
        this.err().notice("creating_root");
        RootDocImpl result = AjdocCompiler.init(this, (String[][])options.toArray((T[])new String[options.size()][]));
        ClassDoc[] cds = result.classes();
        int i3 = 0;
        while (i3 < cds.length) {
            if (cds[i3] instanceof ClassDocImpl) {
                ClassDocImpl cd = (ClassDocImpl)cds[i3];
                cd.postProcess();
            }
            ++i3;
        }
        return result;
    }

    public static AjdocCompiler instance() {
        return instance;
    }

    public static RootDocImpl init(AspectJCompiler ajc, String[][] options) {
        if (ajc == null) {
            return null;
        }
        World world = ajc.getWorld();
        Set classnames = null;
        Set pkgnames = null;
        if (ajc instanceof AjdocCompiler) {
            AjdocCompiler ajdoc = (AjdocCompiler)ajc;
            pkgnames = ajdoc.pkgnames;
            classnames = ajdoc.classnames;
        }
        PackageDocImpl.init(ajc);
        AccessChecker filter = AccessChecker.PUBLIC;
        if (ajc instanceof AjdocCompiler) {
            filter = ((AjdocCompiler)ajc).getFilter();
        }
        RootDocImpl root = new RootDocImpl(world, options, pkgnames, classnames, filter);
        return root;
    }

    protected void setFilter(AccessChecker filter, String arg) {
        this.filter = filter;
    }

    public final AccessChecker getFilter() {
        return this.filter;
    }

    /*
     * WARNING - void declaration
     */
    protected final void expandAtFile(String filename, List args) throws IOException {
        String line;
        BufferedReader in = new BufferedReader(new FileReader(filename));
        String dirfile = new File(filename).getParent();
        File basedir = new File(null == dirfile ? "." : dirfile);
        while ((line = in.readLine()) != null) {
            File parentDir;
            File[] javafiles;
            File newfile;
            void var6_6;
            if (var6_6 == null || var6_6.length() < 1 || (line = var6_6.trim()).startsWith("//") || line.startsWith("#")) continue;
            if (line.startsWith("@")) {
                newfile = new File(line = line.substring(1));
                newfile = newfile.isAbsolute() ? newfile : new File(basedir, line);
                this.expandAtFile(newfile.getPath(), args);
                continue;
            }
            newfile = new File(line);
            File file = newfile = newfile.isAbsolute() ? newfile : new File(basedir, line);
            if (newfile.exists()) {
                boolean result = AjdocCompiler.maybeAdd(newfile, args);
                if (result) continue;
                this.cantResolve(newfile);
                continue;
            }
            boolean addedFile = false;
            FileFilter filter = null;
            String name = newfile.getName().trim();
            if (name.equals("*.java")) {
                filter = new FileFilter(){

                    public boolean accept(File f) {
                        return f != null && f.getName().endsWith(".java");
                    }
                };
            } else if (name.equals("*.aj")) {
                filter = new FileFilter(){

                    public boolean accept(File f) {
                        return f != null && f.getName().endsWith(".java");
                    }
                };
            } else if (name.equals("*")) {
                filter = new FileFilter(){

                    public boolean accept(File f) {
                        return f != null && (f.getName().endsWith(".java") || f.getName().endsWith(".aj"));
                    }
                };
            }
            if (null != filter && (javafiles = (parentDir = newfile.getParentFile()).listFiles(filter)) != null) {
                int i = 0;
                while (i < javafiles.length) {
                    if (AjdocCompiler.maybeAdd(javafiles[i], args)) {
                        if (!addedFile) {
                            addedFile = true;
                        }
                    } else {
                        this.cantResolve(javafiles[i]);
                    }
                    ++i;
                }
            }
            if (addedFile) continue;
            if (AjdocCompiler.isValidPkg(line)) {
                args.add(line);
                continue;
            }
            this.cantResolve(newfile);
        }
        in.close();
    }

    protected final void cantResolve(File f) {
        this.err().error("cant_resolve_file", f.getAbsolutePath());
    }

    private void resolveSourcePath(String sourcepath) {
        if (sourcepath != null) {
            this.sourcepaths.remove(0);
            StringTokenizer t = new StringTokenizer(sourcepath, File.pathSeparator);
            while (t.hasMoreTokens()) {
                File path = new File(t.nextToken().trim());
                if (!path.exists() || !path.isDirectory()) continue;
                this.sourcepaths.add(path);
            }
        }
    }

    private void resolveFilesAndPackages(List filenamesAndPackages) {
        HashSet<String> pkgnamesFromCmd = new HashSet<String>();
        Iterator i = filenamesAndPackages.iterator();
        while (i.hasNext()) {
            String str = (String)i.next();
            File file = new File(str);
            if (AjdocCompiler.maybeAdd(file, this.srcSrcfilenames)) {
                this.addFile(file);
                continue;
            }
            Iterator j = this.sourcepaths.iterator();
            while (j.hasNext()) {
                File sourcepath = (File)j.next();
                file = new File(sourcepath, str);
                if (!AjdocCompiler.maybeAdd(file, this.srcSrcfilenames)) continue;
                this.addFile(file);
            }
            pkgnamesFromCmd.add(str);
        }
        Iterator i2 = pkgnamesFromCmd.iterator();
        while (i2.hasNext()) {
            this.resolvePackageOrClass((String)i2.next());
        }
    }

    private void resolvePackageOrClass(String pkgOrClassName) {
        boolean recurse = pkgOrClassName.endsWith(".*");
        String pkgOrClass = recurse ? pkgOrClassName.substring(0, pkgOrClassName.length() - 2) : pkgOrClassName;
        Iterator i = this.sourcepaths.iterator();
        while (i.hasNext()) {
            File file;
            File sourcepath = (File)i.next();
            File possiblePkg = new File(sourcepath, pkgOrClass.replace('.', File.separatorChar));
            if (possiblePkg.exists() && possiblePkg.isDirectory()) {
                File[] javafiles;
                if (recurse) {
                    File[] dirs = possiblePkg.listFiles(new FileFilter(){

                        public boolean accept(File f) {
                            return f != null && f.isDirectory();
                        }
                    });
                    int j = 0;
                    while (j < dirs.length) {
                        String pkgname = pkgOrClass + '.' + dirs[j].getName();
                        this.resolvePackageOrClass(pkgname + ".*");
                        ++j;
                    }
                }
                if ((javafiles = possiblePkg.listFiles(new FileFilter(){

                    public boolean accept(File f) {
                        return f != null && !f.isDirectory();
                    }
                })).length > 0) {
                    this.pkgnames.add(pkgOrClass);
                }
                boolean addedPkg = false;
                int j = 0;
                while (j < javafiles.length) {
                    if (AjdocCompiler.maybeAdd(javafiles[j], this.pkgSrcfilenames) && !addedPkg) {
                        this.addPkg(pkgOrClass, javafiles[j]);
                        addedPkg = true;
                    }
                    ++j;
                }
                break;
            }
            String pkgname = "";
            String classname = pkgOrClass;
            int ilastdot = pkgOrClass.lastIndexOf(46);
            if (ilastdot != -1) {
                pkgname = pkgOrClass.substring(0, ilastdot).replace('.', File.separatorChar) + File.separatorChar;
                classname = pkgOrClass.substring(ilastdot + 1);
            }
            if (!AjdocCompiler.maybeAdd(file = new File(sourcepath, pkgname + classname + ".java"), this.clsSrcfilenames)) continue;
            this.addClass(pkgOrClass, file);
            break;
        }
    }

    protected final File findFile(String filename, boolean isDir) {
        Iterator i = this.sourcepaths.iterator();
        while (i.hasNext()) {
            File sourcepath = (File)i.next();
            File file = new File(sourcepath, filename);
            if (!file.exists() || isDir ^ file.isDirectory()) continue;
            return file;
        }
        return null;
    }

    protected static boolean maybeAddPkg(String pkgname, Collection pkgnames) {
        if (AjdocCompiler.isValidPkg(pkgname)) {
            pkgnames.add(pkgname);
            return true;
        }
        return false;
    }

    protected final void addClass(String classname, File file) {
        if (!this.maybeAddClass(classname)) {
            this.err().error("invalid_class_name", classname);
        } else {
            this.filesToClassnames.put(file.getAbsoluteFile(), classname);
        }
    }

    protected final boolean maybeAddClass(String classname) {
        return AjdocCompiler.maybeAddClass(classname, this.classnames);
    }

    protected static boolean maybeAddClass(String classname, Collection classnames) {
        if (AjdocCompiler.isValidClass(classname)) {
            classnames.add(classname);
            return true;
        }
        return false;
    }

    protected static final boolean isValidClass(String classname) {
        return AjdocCompiler.isValidPkg(classname);
    }

    protected final void addPkg(String pkgname, File file) {
        if (!this.maybeAddPkg(pkgname)) {
            this.err().error("invalid_package_name", pkgname);
        } else {
            this.filesToPkgnames.put(file.getAbsoluteFile(), pkgname);
        }
    }

    protected final boolean maybeAddPkg(String pkgname) {
        return AjdocCompiler.maybeAddPkg(pkgname, this.pkgnames);
    }

    protected final void addFile(File file) {
        this.files.add(file);
        this.filesToFilenames.put(file.getAbsoluteFile(), file.getAbsolutePath());
    }

    protected static boolean maybeAdd(File file, Collection files) {
        if (AjdocCompiler.isValidJavaFile(file)) {
            files.add(file.getAbsolutePath());
            return true;
        }
        return false;
    }

    protected static final boolean isValidJavaFile(File file) {
        return file != null && file.exists() && !file.isDirectory() && (file.getName().endsWith(".java") || file.getName().endsWith(".aj"));
    }

    protected static final boolean isValidPkg(String pkgname) {
        if (pkgname == null) {
            return false;
        }
        if (pkgname.length() < 1) {
            return true;
        }
        if (!Character.isJavaIdentifierStart(pkgname.charAt(0))) {
            return false;
        }
        int i = 1;
        while (i < pkgname.length()) {
            char c = pkgname.charAt(i);
            if (c == '.' && i == pkgname.length() - 1) {
                return false;
            }
            if (c != '.' && !Character.isJavaIdentifierPart(c)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void loading(CompilationUnit cu) {
        File srcfile = cu.getSourceFile().getAbsoluteFile();
        String pkgname = (String)this.filesToPkgnames.get(srcfile);
        if (pkgname != null) {
            this.err().notice("Loading_source_files_for_package", pkgname);
        } else {
            String classname = (String)this.filesToClassnames.get(srcfile);
            if (classname != null) {
                this.err().notice("Loading_source_file_for_class", classname);
            } else {
                String filename = (String)this.filesToFilenames.get(srcfile);
                if (filename != null) {
                    this.err().notice("Loading_source_file", filename);
                }
            }
        }
    }

    protected AbstractCompilerPass createParserPass() {
        return new PrintingParserPass(this);
    }

    protected void addPasses() {
        this.passes = new ArrayList();
        this.addPreSymbolPasses();
    }

    protected static class PrintingParserPass
    extends AspectJCompiler.ParserPass {
        public PrintingParserPass(AjdocCompiler jc) {
            super(jc);
        }

        public void transform(CompilationUnit cu) {
            ((AjdocCompiler)this.getCompiler()).loading(cu);
            super.transform(cu);
        }
    }
}

