/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import com.sun.javadoc.RootDoc;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.aspectj.compiler.base.CompilerErrors;
import org.aspectj.compiler.base.ExitRequestException;
import org.aspectj.compiler.base.InternalCompilerError;
import org.aspectj.tools.ajdoc.AccessChecker;
import org.aspectj.tools.ajdoc.AjdocCompiler;
import org.aspectj.tools.ajdoc.CannotMakeRootDocException;
import org.aspectj.tools.ajdoc.DocletProxy;
import org.aspectj.tools.ajdoc.RootDocMaker;

public class Ajdoc
extends AjdocCompiler {
    private static final int VERBOSE = 1;
    private static final int WARNINGS = 4;
    private DocletProxy docletProxy;
    private RootDocMaker rootDocMaker;
    private String source = null;
    private String extdirs = null;
    private String locale = null;
    private String encoding = null;
    private String sourcepath = null;
    private String classpath = null;
    private String bootclasspath = null;
    private int verbosity = 4;
    private List filenamesAndPackages = new ArrayList();
    private List options = new ArrayList();

    public Ajdoc(String programName) {
        super(programName);
    }

    public Ajdoc() {
        this("ajdoc");
    }

    public int execute(String[] args) {
        try {
            return this.doc(args) && this.err.getNumErrors() == 0 ? 0 : 1;
        }
        catch (ExitRequestException exit) {
            return exit.getValue();
        }
        catch (CompilerErrors err) {
            return err.errors;
        }
        catch (InternalCompilerError error) {
            this.handleInternalError(error.uncaughtThrowable);
            error.showWhere(new PrintWriter(System.err));
            return -2;
        }
        catch (Exception e) {
            e.printStackTrace(System.err);
            this.err.internalError("internal_msg", e);
            return 1;
        }
    }

    public void handleInternalError(Throwable uncaughtThrowable) {
        System.err.println("An internal error occured in Ajdoc invocation of AspectJ-" + this.getCompiler().getVersion());
        System.err.println(uncaughtThrowable.toString());
        uncaughtThrowable.printStackTrace(System.err);
        System.err.println();
    }

    public boolean doc(String[] args) {
        long start = System.currentTimeMillis();
        if (args == null) {
            this.err.error("internal_error", "Arguments cannot be null");
            return false;
        }
        try {
            args = this.expandAndCreateDoclet(args);
        }
        catch (FileNotFoundException e) {
            this.err.error("file_not_found_exception", e.getMessage());
            return false;
        }
        catch (IOException e) {
            this.err.error("io_exception", e.getMessage());
            return false;
        }
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]).equals("-overview")) {
                this.set(args, i++);
                continue;
            }
            if (arg.equals("-public")) {
                this.set(arg);
                if (this.filter != null) {
                    this.err.error("argument_already_seen", arg);
                    continue;
                }
                this.setFilter(AccessChecker.PUBLIC, arg);
                continue;
            }
            if (arg.equals("-protected")) {
                this.set(arg);
                if (this.filter != null) {
                    this.err.error("argument_already_seen", arg);
                    continue;
                }
                this.setFilter(AccessChecker.PROTECTED, arg);
                continue;
            }
            if (arg.equals("-package")) {
                this.set(arg);
                if (this.filter != null) {
                    this.err.error("argument_already_seen", arg);
                    continue;
                }
                this.setFilter(AccessChecker.PACKAGE, arg);
                continue;
            }
            if (arg.equals("-private")) {
                this.set(arg);
                if (this.filter != null) {
                    this.err.error("argument_already_seen", arg);
                    continue;
                }
                this.setFilter(AccessChecker.PRIVATE, arg);
                continue;
            }
            if (arg.equals("-help")) {
                this.usage(0);
                continue;
            }
            if (arg.equals("-sourcepath")) {
                if (this.sourcepath != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.sourcepath = this.set(args, i++);
                continue;
            }
            if (arg.equals("-classpath")) {
                if (this.classpath != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.classpath = this.set(args, i++);
                continue;
            }
            if (arg.equals("-bootclasspath")) {
                if (this.bootclasspath != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.bootclasspath = this.set(args, i++);
                continue;
            }
            if (arg.equals("-source")) {
                if (this.source != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.source = this.set(args, i++);
                continue;
            }
            if (arg.equals("-extdirs")) {
                if (this.extdirs != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.extdirs = this.set(args, i++);
                continue;
            }
            if (arg.equals("-verbose")) {
                this.set(arg);
                this.verbosity |= 1;
                continue;
            }
            if (arg.equals("-locale")) {
                if (this.locale != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.set(args, i++);
                continue;
            }
            if (arg.equals("-encoding")) {
                if (this.encoding != null) {
                    this.usage("argument_already_seen", arg);
                }
                this.encoding = this.set(args, i++);
                continue;
            }
            if (arg.equals("-compiler")) {
                this.err.warning("usage_help", "-compiler option ignored");
                continue;
            }
            if (arg.equals("-debug")) {
                this.err.warning("usage_help", "-debug option disabled");
                continue;
            }
            if (arg.startsWith("-J")) {
                String val;
                String key;
                if (arg.length() == 2) continue;
                String rest = arg.substring(2);
                int ieq = rest.indexOf(61);
                if (ieq != -1) {
                    key = rest.substring(0, ieq);
                    val = rest.substring(ieq + 1);
                } else {
                    key = rest;
                    val = "";
                }
                System.setProperty(key, val);
                continue;
            }
            if (arg.startsWith("-")) {
                int optionLength = this.docletProxy.optionLength(arg);
                if (optionLength < 0) {
                    this.exit();
                    continue;
                }
                if (optionLength == 0) {
                    this.usage("invalid_flag", arg);
                    continue;
                }
                if (optionLength > args.length) {
                    this.usage("requires_argument", arg, optionLength + "");
                    continue;
                }
                ArrayList<String> iargs = new ArrayList<String>();
                iargs.add(arg);
                int j = 0;
                while (j < optionLength - 1) {
                    iargs.add(args[i++]);
                    ++j;
                }
                this.set(iargs.toArray(new String[iargs.size()]));
                continue;
            }
            this.filenamesAndPackages.add(arg);
        }
        if (this.locale == null) {
            this.locale = "";
        }
        if (this.sourcepath == null) {
            this.sourcepath = ".";
        }
        try {
            if (!this.docletProxy.validOptions(this.options, this.err)) {
                this.exit(1);
            }
        }
        catch (IOException e) {
            e.printStackTrace(System.err);
            this.err.internalError("internal_msg", e);
            return false;
        }
        if (this.filenamesAndPackages.size() < 1) {
            this.usage("No_packages_or_classes_specified");
            return false;
        }
        RootDoc rootDoc = null;
        boolean good = true;
        try {
            rootDoc = this.makeRootDoc(this.sourcepath, this.classpath, this.bootclasspath, this.extdirs, this.verbosity, this.encoding, this.locale, this.source, this.filenamesAndPackages, this.options, this.err, this.programName, this.getFilter());
        }
        catch (CannotMakeRootDocException e) {
            this.err.error("cant_create_root_doc_ex", "AjdocCompiler", e.getMessage());
            this.exit(1);
            good = false;
        }
        if (good &= rootDoc != null) {
            this.err.notice("generating_docs");
            try {
                good &= this.docletProxy.start(rootDoc);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
                this.err.internalError("internal_msg", e);
                return false;
            }
        }
        if ((this.verbosity & 1) != 0) {
            this.err.notice("done_in", Long.toString(System.currentTimeMillis() - start));
        }
        return good;
    }

    private void usage(String key, String s0, String s1) {
        this.err.error(key, s0, s1);
        this.usage(1);
    }

    private void usage(String key, String s0) {
        this.usage(key, s0, "");
    }

    private void usage(String key) {
        this.usage(key, "");
    }

    private void usage() {
        this.err.notice("usage_help", this.programName);
        if (this.docletProxy != null) {
            this.docletProxy.optionLength("-help");
        }
    }

    private void usage(int exit) {
        this.usage();
        this.exit(exit);
    }

    protected String[] expandAndCreateDoclet(String[] args) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        this.docletProxy = DocletProxy.DEFAULT;
        int i = 0;
        while (i < args.length) {
            String arg;
            if ((arg = args[i++]) == null || arg.length() < 1) continue;
            if (arg.charAt(0) == '@') {
                this.expandAtFile(arg.substring(1), list);
                continue;
            }
            if (arg.equals("-argfile")) {
                if (!Ajdoc.check(args, i)) continue;
                this.expandAtFile(args[i++], list);
                continue;
            }
            if (arg.equals("-doclet")) {
                this.err.warning("usage_help", "-doclet option ignored");
                continue;
            }
            if (arg.equals("-docletpath")) {
                this.err.warning("usage_help", "-docletpath option ignored");
                continue;
            }
            if (arg.equals("-standard")) {
                this.docletProxy = DocletProxy.STANDARD;
                continue;
            }
            list.add(arg);
        }
        return list.toArray(new String[list.size()]);
    }

    private static boolean check(String[] args, int i) {
        return i >= 0 && i < args.length;
    }

    private String set(String[] args, int i) {
        String arg = null;
        if (Ajdoc.check(args, i)) {
            arg = args[i];
            this.set(args[i - 1], arg);
        } else {
            this.err.internalError("internal_error", new ArrayIndexOutOfBoundsException(i));
        }
        return arg;
    }

    private void set(String opt) {
        this.set(new String[]{opt});
    }

    private void set(String opt, String arg) {
        this.set(new String[]{opt, arg});
    }

    private void set(String[] opts) {
        this.options.add(opts);
    }

    protected void internalCompile(List filenames) {
        super.internalCompile(filenames);
    }

    private final void exit() {
        this.exit(0);
    }

    private void exit(int exit) {
        throw new ExitRequestException(exit);
    }

    private static String classname(Object o) {
        return o != null ? o.getClass().getName() : "null";
    }
}

