/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdoc;

import org.aspectj.compiler.base.ast.CodeDec;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;

public abstract class AccessChecker {
    public static final AccessChecker PUBLIC = new AccessChecker("public"){

        public boolean doCanAccess(Modifiers mods, Object object) {
            return mods.isPublic();
        }
    };
    public static final AccessChecker PROTECTED = new AccessChecker("protected"){

        public boolean doCanAccess(Modifiers mods, Object object) {
            return mods.isPublic() || mods.isProtected();
        }
    };
    public static final AccessChecker PACKAGE = new AccessChecker("package"){

        public boolean doCanAccess(Modifiers mods, Object object) {
            return !mods.isPrivate();
        }
    };
    public static final AccessChecker PRIVATE = new AccessChecker("private"){

        public boolean doCanAccess(Modifiers mods, Object object) {
            return true;
        }
    };
    protected final String optionName;

    protected AccessChecker(String optionName) {
        this.optionName = optionName;
    }

    public boolean canAccess(FieldDec dec) {
        if (null == dec) {
            return false;
        }
        if (!this.canAccess(dec.getModifiers(), dec)) {
            return false;
        }
        return this.canAccess(dec.getBytecodeTypeDec());
    }

    public boolean canAccess(CodeDec dec) {
        if (null == dec) {
            return false;
        }
        if (!this.canAccess(dec.getModifiers(), dec)) {
            return false;
        }
        return this.canAccess(dec.getBytecodeTypeDec());
    }

    public boolean canAccess(PointcutDec dec) {
        if (null == dec) {
            return false;
        }
        if (!this.canAccess(dec.getModifiers(), dec)) {
            return false;
        }
        return this.canAccess(dec.getBytecodeTypeDec());
    }

    public boolean canAccess(TypeDec dec) {
        if (null == dec) {
            return false;
        }
        boolean result = this.canAccess(dec.getModifiers(), dec);
        if (result) {
            NameType outerType = dec.getEnclosingInstanceType();
            TypeDec outer = null == outerType ? null : outerType.getTypeDec();
            result = null == outer || this.canAccess(outer);
        }
        return result;
    }

    protected boolean canAccessLog(Modifiers mods, Object object, boolean result) {
        return result;
    }

    public final boolean canAccess(Modifiers mods, Object object) {
        boolean result = null == mods ? false : this.doCanAccess(mods, object);
        return this.canAccessLog(mods, object, result);
    }

    public final String getOption() {
        return this.optionName;
    }

    public final String toString() {
        return this.optionName.toUpperCase();
    }

    protected abstract boolean doCanAccess(Modifiers var1, Object var2);
}

