/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.tools.ajdb;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.ide.FullPathSourceShower;
import org.aspectj.debugger.ide.IDEInterface;
import org.aspectj.debugger.ide.IDEInterfaceImpl;
import org.aspectj.debugger.ide.SourceShower;
import org.aspectj.debugger.tty.CommandLineDebugger;
import org.aspectj.util.gui.CenteredJFrame;

public class Main {
    public static void main(String[] args) {
        new Main().debug(args);
    }

    public CommandLineDebugger debug(String[] args) {
        CommandLineDebugger debugger = null;
        boolean launch = false;
        boolean gui = false;
        boolean forte = false;
        boolean jbuilder = false;
        boolean wantsToExit = true;
        SourceShower shower = FullPathSourceShower.proto;
        IDEInterface ide = IDEInterfaceImpl.proto;
        int i = 0;
        while (i < args.length) {
            if (args[i].equals("-noexit")) {
                wantsToExit = false;
                System.setProperty("no.logger", "true");
                args = this.shift(args, i--);
            } else if (args[i].equals("-launch")) {
                launch = true;
                args = this.shift(args, i--);
            } else if (args[i].equals("-gui")) {
                gui = true;
                args = this.shift(args, i--);
            } else if (args[i].equals("-forte")) {
                forte = true;
                args = this.shift(args, i--);
            } else if (args[i].equals("-jbuilder")) {
                jbuilder = true;
                args = this.shift(args, i--);
            } else if (args[i].equals("-ide")) {
                args = this.shift(args, i);
                try {
                    ide = (IDEInterface)Class.forName(args[i]).newInstance();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                args = this.shift(args, i);
            } else if (args[i].equals("-shower")) {
                args = this.shift(args, i);
                try {
                    shower = (SourceShower)Class.forName(args[i]).newInstance();
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
                args = this.shift(args, i);
            }
            ++i;
        }
        if (gui) {
            new ComponentDirector(args).go();
        }
        debugger = new CommandLineDebugger(args);
        if (!gui) {
            debugger.setWantsToExit(wantsToExit);
        }
        debugger.go();
        return debugger;
    }

    private String[] shift(String[] args, int i) {
        String[] newArgs = new String[args.length - 1];
        System.arraycopy(args, 0, newArgs, 0, i);
        System.arraycopy(args, i + 1, newArgs, i, args.length - i - 1);
        return newArgs;
    }

    private abstract class AbstractLauncher
    extends CenteredJFrame {
        private static final int TEXT_WIDTH = 30;
        private JTextField mainClassField = new JTextField(30);
        private JTextField classpathField = new JTextField(30);
        private JTextField sourcepathField = new JTextField(30);
        protected SourceShower shower;
        protected IDEInterface ide;
        protected String[] args;
        private JButton launchButton;

        protected SourceShower shower() {
            return this.shower;
        }

        private void launch() {
            Vector<String> list = new Vector<String>();
            int i = 0;
            while (i < this.args.length) {
                list.add(this.args[i]);
                ++i;
            }
            this.add(list, "-classpath", this.classpathField);
            this.add(list, "-sourcepath", this.sourcepathField);
            this.add(list, "-now", this.mainClassField);
            System.out.println("args: " + list);
            String[] newArgs = new String[list.size()];
            Iterator iter = list.iterator();
            int i2 = 0;
            while (iter.hasNext()) {
                newArgs[i2++] = iter.next() + "";
            }
            ComponentDirector cd = this.debugger(newArgs);
            cd.go();
        }

        private void add(Collection list, String arg, JTextField field) {
            String text = field.getText().trim();
            if (text == null || text.length() == 0) {
                return;
            }
            if (arg.length() > 0) {
                list.add(arg);
                list.add(text);
            } else {
                list.add(text);
            }
        }

        protected abstract ComponentDirector debugger(String[] var1);

        protected abstract String getIDEName();

        AbstractLauncher(String[] args, SourceShower shower, IDEInterface ide) {
            this.mainClassField.setText("New");
            this.sourcepathField.setText("C:/ajdb-src");
            this.args = null;
            this.launchButton = new JButton(new AbstractAction(this, "Launch debugger"){
                private final /* synthetic */ AbstractLauncher this$1;
                {
                    this.this$1 = this$1;
                }

                public void actionPerformed(ActionEvent e) {
                    AbstractLauncher.access$000(this.this$1);
                    ((Component)this.this$1).setVisible(false);
                    this.this$1.dispose();
                }
            });
            this.setTitle(this.getIDEName() + " Debugger Launcher");
            this.args = args;
            this.shower = shower;
            this.ide = ide;
            Container c = this.getContentPane();
            c.setLayout(new BoxLayout(c, 1));
            c.add(this.p("Main class", this.mainClassField));
            c.add(this.p("Class path", this.classpathField));
            c.add(this.p("Source path", this.sourcepathField));
            c.add(this.launchButton);
            this.launchButton.requestFocus();
            this.setDefaultCloseOperation(3);
        }

        void go() {
            this.pack();
            ((Component)this).setVisible(true);
        }

        private Component p(String title, Component c2) {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 0));
            p.add(new JLabel(title + ": "));
            p.add(c2);
            return p;
        }

        static /* synthetic */ void access$000(AbstractLauncher x0) {
            x0.launch();
        }
    }
}

