/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.ThreadRequestAction;

public class TraceMethodsRequest
extends Request {
    private String threadName;

    public TraceMethodsRequest(Debugger debugger, String threadName) {
        super(debugger);
        this.threadName = threadName;
    }

    public Object go() throws NoVMException, DebuggerException {
        MethodEntryRequest entry = (MethodEntryRequest)new MethodEntryRequestAction(this.dbg(), this.threadName).go();
        MethodExitRequest exit = (MethodExitRequest)new MethodExitRequestAction(this.dbg(), this.threadName).go();
        return new EntryExitPair(entry, exit);
    }

    static class MethodExitRequestAction
    extends ThreadRequestAction {
        public MethodExitRequestAction(Debugger debugger, String threadName) {
            super(debugger, threadName);
        }

        public Object go() throws NoVMException, DebuggerException {
            return this.set();
        }

        boolean isEnter() {
            return false;
        }
    }

    static class MethodEntryRequestAction
    extends ThreadRequestAction {
        public MethodEntryRequestAction(Debugger debugger, String threadName) {
            super(debugger, threadName);
        }

        public Object go() throws NoVMException, DebuggerException {
            return this.set();
        }

        boolean isEnter() {
            return true;
        }
    }

    public static class EntryExitPair {
        private MethodEntryRequest entry;
        private MethodExitRequest exit;

        public EntryExitPair(MethodEntryRequest entry, MethodExitRequest exit) {
            this.entry = entry;
            this.exit = exit;
        }

        public MethodEntryRequest getEntry() {
            return this.entry;
        }

        public MethodExitRequest getExit() {
            return this.exit;
        }

        public String toString() {
            return "TRACE\n\tEntry: " + this.entry + "\n\t" + "Exit: " + this.exit;
        }
    }
}

