/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ThreadReference;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.ThreadsNotFoundException;
import org.aspectj.debugger.request.Request;

public abstract class ThreadsNeedingRequest
extends Request {
    protected List threadNames;

    public ThreadsNeedingRequest(Debugger debugger, List threadNames) {
        super(debugger);
        this.threadNames = threadNames;
    }

    public List getThreads() throws NoVMException, DebuggerException {
        if (this.threadNames == null || this.threadNames.size() == 0) {
            return this.vm().allThreads();
        }
        Iterator namesIter = this.threadNames.iterator();
        ArrayList<ThreadReference> threads = new ArrayList<ThreadReference>();
        ArrayList<String> badThreads = new ArrayList<String>();
        while (namesIter.hasNext()) {
            String threadName = namesIter.next() + "";
            Iterator<ThreadReference> iter = this.vm().allThreads().iterator();
            boolean found = false;
            while (iter.hasNext()) {
                ThreadReference threadRef = iter.next();
                if (threadRef.name().equals(threadName)) {
                    found = true;
                    threads.add(threadRef);
                    break;
                }
                try {
                    long ourID = Long.parseLong(threadName);
                    long refID = threadRef.uniqueID();
                    if (ourID != refID) continue;
                    found = true;
                    threads.add(threadRef);
                    break;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            if (found) continue;
            badThreads.add(threadName);
        }
        if (badThreads.size() > 0) {
            throw new ThreadsNotFoundException(badThreads);
        }
        return threads;
    }
}

