/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.ThreadListener;
import org.aspectj.debugger.request.TextPrintingRequest;

public class ThreadTextPrintingRequest
extends TextPrintingRequest
implements ThreadListener {
    public static final int START = 1;
    public static final int DEATH = 16;
    public static final int START_OR_DEATH = 17;
    protected int mode;

    public ThreadTextPrintingRequest(Debugger debugger, int mode, String text) {
        super(debugger, text);
        if (mode < 1 || mode > 17) {
            throw new IllegalArgumentException("mode:" + mode + " where " + 1 + "<=mode<=" + 17);
        }
        this.mode = mode;
    }

    public Object go() throws NoVMException, DebuggerException {
        this.debugger.addThreadListener(this);
        return this.text;
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
        if ((this.mode & 1) != 0) {
            this.print();
        }
    }

    public void threadStartEvent(ThreadStartEvent e) {
        if ((this.mode & 0x10) != 0) {
            this.print();
        }
    }
}

