/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import java.io.File;
import java.util.List;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.UnableToSetRequestException;
import org.aspectj.tools.ide.SourceLine;

public abstract class SourceLineBreakpointRequestAction
extends BreakpointRequestAction {
    protected String sourceName;
    protected int line;

    public SourceLineBreakpointRequestAction(Debugger debugger, String sourceName, int line) {
        super(debugger);
        System.err.println(">> source line request: " + sourceName + " : " + line);
        this.sourceName = this.ensureDriveIsUpperCase(sourceName);
        this.line = line;
    }

    EventRequest resolve(ReferenceType refType) throws MultipleLocationsException, UnableToSetRequestException {
        BreakpointRequest request = null;
        try {
            String refTypeSourceName = refType.sourceName();
            String strippedName = this.ajdbg().strip(this.getSourceName());
            if (refTypeSourceName.equals(strippedName)) {
                EventRequestManager em = this.vm().eventRequestManager();
                Location location = this.findLocation(refType);
                if (location == null) {
                    return null;
                }
                request = this.request(location);
            }
        }
        catch (NoVMException e) {
        }
        catch (AbsentInformationException aie) {
            // empty catch block
        }
        return request;
    }

    private String ensureDriveIsUpperCase(String sourceName) {
        try {
            if (Character.isLetter(sourceName.charAt(0)) && sourceName.charAt(1) == ':' && this.isFileSeparator(sourceName.charAt(2))) {
                return Character.toUpperCase(sourceName.charAt(0)) + sourceName.substring(1);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        return sourceName;
    }

    private boolean isFileSeparator(char c) {
        return c == File.separatorChar || c == '/' || c == '\\';
    }

    private Location findLocation(ReferenceType refType) throws MultipleLocationsException, UnableToSetRequestException {
        Location location = null;
        try {
            List<Location> lines = refType.locationsOfLine(this.line);
            if (lines == null || lines.size() == 0) {
                return null;
            }
            location = lines.get(0);
        }
        catch (AbsentInformationException aie) {
            this.ajdbg().exception("Unable to set " + this + " : No code at line " + this.line + " in " + refType.name(), aie);
        }
        catch (ClassNotPreparedException cpe) {
            this.ajdbg().classNotPreparedException(cpe, refType.name());
        }
        catch (ObjectCollectedException oce) {
            this.ajdbg().objectCollectedException(oce, refType.name());
        }
        catch (InvalidLineNumberException ilne) {
            this.ajdbg().invalidLineNumberException(ilne, refType.name(), this.line);
        }
        return location;
    }

    public int getLine() {
        return this.line;
    }

    public String getSourceName() {
        return this.sourceName;
    }

    public int getRealLine() {
        SourceLine sl = this.sourceLine();
        if (sl == null || sl.line < 0) {
            return super.getRealLine();
        }
        return sl.line;
    }

    public String getRealSourceName() {
        SourceLine sl = this.sourceLine();
        if (sl == null) {
            return super.getRealSourceName();
        }
        return sl.filename;
    }

    public SourceLine sourceLine() {
        return this.ajdbg().getSourceLineFromSource(this.getSourceName(), this.getLine());
    }

    public String getProto() {
        SourceLine sl = this.ajdbg().getSourceLineFromSource(this.getSourceName(), this.getLine());
        String newSource = "<source-unkown>";
        if (sl != null) {
            newSource = this.ajdbg().strip(this.ajdbg().removeFullWorkingDir(sl.filename));
        } else {
            System.out.println("sl is NULL: " + this.sourceName + ":" + this.getLine());
        }
        return newSource + ":" + sl.line;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof SourceLineBreakpointRequestAction)) {
            return super.equals(other);
        }
        SourceLineBreakpointRequestAction ba = (SourceLineBreakpointRequestAction)other;
        return this.getSourceName().equals(ba.getSourceName()) && this.getLine() == ba.getLine();
    }

    public String getErrorMessage() {
        SourceLine sl = this.ajdbg().getSourceLineFromSource(this.getSourceName(), this.getLine());
        String newSourceName = this.getSourceName();
        int newLine = this.getLine();
        if (sl != null) {
            newSourceName = this.ajdbg().removeSourcePath(sl.filename);
            newLine = sl.line;
        }
        return "No code at line " + newLine + " in file " + newSourceName;
    }
}

