/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.StackFrame;
import com.sun.jdi.Value;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.ExpressionGettingRequest;

public class SetRequest
extends ExpressionGettingRequest {
    private Object lvalue;

    public SetRequest(Debugger debugger, Object lvalue, Object rvalue) {
        super(debugger, rvalue);
        this.lvalue = lvalue;
    }

    public Object go() throws NoVMException, DebuggerException {
        Value value = this.getValue();
        StackFrame frame = this.dbg().getDefaultFrame();
        LocalVariable local = this.eval().getLocalVariable(this.lvalue, frame);
        try {
            frame.setValue(local, value);
        }
        catch (InvalidTypeException ite) {
            throw new DebuggerException(ite);
        }
        catch (ClassNotLoadedException cnle) {
            throw new DebuggerException(cnle);
        }
        return frame.getValue(local);
    }
}

