/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.RequestAction;
import org.aspectj.debugger.request.RequestEvent;

public abstract class RequestActionSupport
extends Request
implements VMListener,
StopListener {
    protected boolean isSet = false;
    protected EventRequest request;
    protected String text;
    private boolean isDeferred = false;
    private SourceManager.SourceLine sourceLine;
    protected boolean isEnabled = true;

    public RequestActionSupport setText(String text) {
        this.text = text;
        return this;
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public RequestActionSupport(Debugger debugger, String text) {
        super(debugger);
        if (text != null && !text.trim().equals("")) {
            debugger.addStopListener(this);
        }
        this.setText(text);
    }

    public RequestActionSupport(Debugger debugger) {
        this(debugger, null);
    }

    abstract void resolveAll();

    public boolean isSetting() {
        return true;
    }

    public boolean isBreakpoint() {
        return false;
    }

    public boolean isSet() {
        return this.isSet;
    }

    public EventRequest setRequest(EventRequest request) {
        this.request = request;
        return this.request;
    }

    protected EventRequest set() {
        this.add();
        try {
            this.resolveAll();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
        return this.getRequest();
    }

    protected EventRequest unset() {
        RequestAction request = this.remove();
        EventRequest req = null;
        if (request != null) {
            try {
                req = request.getRequest();
                if (req != null) {
                    this.vm().eventRequestManager().deleteEventRequest(req);
                }
            }
            catch (NoVMException e) {}
        } else {
            try {
                req = this.getRequest();
                req = this.getRequest();
                if (req != null) {
                    this.vm().eventRequestManager().deleteEventRequest(req);
                }
            }
            catch (NoVMException noVMException) {
                // empty catch block
            }
        }
        return req;
    }

    public static String f(BreakpointRequest req) {
        String str = req + "";
        str = str + ", suspendPolicy=" + req.suspendPolicy();
        str = str + ", enabled=" + req.isEnabled();
        str = str + ", location=" + req.location();
        return str;
    }

    public EventRequest getRequest() {
        return this.request;
    }

    public boolean isDeferred() {
        return this.isDeferred;
    }

    protected void setDeferred(boolean isDeferred) {
        this.isDeferred = isDeferred;
    }

    protected VirtualMachine vm() throws NoVMException {
        return this.debugger.getVM();
    }

    protected void addListeners() {
        this.debugger.addVMListener(this);
    }

    protected void add() {
        this.addListeners();
        this.debugger.addRequest(this);
        this.isEnabled = true;
    }

    protected void removeListeners() {
        this.debugger.removeVMListener(this);
    }

    protected RequestAction remove() {
        this.removeListeners();
        RequestAction req = this.debugger.removeRequest(this);
        this.isEnabled = false;
        if (req != null) {
            this.dbg().fireRequestClearEvent(new RequestEvent(this, true));
        }
        return req;
    }

    public SourceManager.SourceLine getSourceLine() {
        return this.sourceLine;
    }

    public void setSourceLine(SourceManager.SourceLine sourceLine) {
        this.sourceLine = sourceLine;
    }

    protected boolean success() {
        if (this.isSetting()) {
            this.dbg().setStatus("Set " + this);
            this.dbg().fireRequestSetEvent(new RequestEvent(this, true));
        } else {
            this.dbg().setStatus("Clear " + this);
            this.dbg().fireRequestClearEvent(new RequestEvent(this, true));
        }
        this.isSet = true;
        return true;
    }

    protected boolean defer() {
        this.setDeferred(true);
        this.dbg().fireRequestDeferredEvent(new RequestEvent(this, false));
        this.isSet = false;
        return false;
    }

    protected boolean failure(boolean verbose) {
        this.dbg().setStatus("Deferring " + this);
        if (verbose) {
            this.dbg().fireRequestFailedEvent(new RequestEvent(this, false));
        }
        this.isSet = false;
        return false;
    }

    private void reset() {
        this.isSet = false;
        this.request = null;
    }

    public void vmStartEvent(VMStartEvent e) {
        if (!this.isSet()) {
            this.resolveAll();
        }
    }

    public void vmDeathEvent(VMDeathEvent e) {
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
    }

    public void breakpointEvent(BreakpointEvent e) {
    }

    public void exceptionEvent(ExceptionEvent e) {
    }

    public void accessWatchpointEvent(AccessWatchpointEvent e) {
    }

    public void modificationWatchpointEvent(ModificationWatchpointEvent e) {
    }

    public void stepEvent(StepEvent e) {
    }

    protected String format(String str) {
        return str;
    }

    protected void print(Event e) {
        if (this.isEnabled() && this.text != null && e != null && e.request().equals(this.request)) {
            this.debugger.app().outln(this.format(this.text));
        }
    }
}

