/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.request.EventRequest;
import java.util.Iterator;
import org.aspectj.debugger.base.ClassListener;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.MultipleLocationsException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.RequestActionSupport;
import org.aspectj.debugger.request.UnableToSetRequestException;

public abstract class RequestAction
extends RequestActionSupport
implements ClassListener {
    public RequestAction(Debugger debugger) {
        super(debugger);
    }

    void resolveAll() {
        this.resolveAgainstAllClasses();
    }

    protected void addListeners() {
        super.addListeners();
        this.debugger.addClassListener(this);
    }

    protected void removeListeners() {
        super.removeListeners();
        this.debugger.removeClassListener(this);
    }

    public void removeFromDebugger(Debugger debugger) {
        this.removeListeners();
    }

    abstract EventRequest resolve(ReferenceType var1) throws MultipleLocationsException, UnableToSetRequestException;

    protected boolean resolveAgainstAllClasses() {
        try {
            Iterator<ReferenceType> iter = this.debugger.getVM().allClasses().iterator();
            while (iter.hasNext()) {
                EventRequest request = this.resolve(iter.next());
                if (request == null) continue;
                this.setRequest(request);
                return this.success();
            }
        }
        catch (NoVMException e) {
        }
        catch (MultipleLocationsException mle) {
            return this.failure(true);
        }
        catch (UnableToSetRequestException utsre) {
            return this.failure(true);
        }
        return this.defer();
    }

    protected boolean resolveAgainstClass(ReferenceType refType) {
        try {
            EventRequest request = this.resolve(refType);
            if (request != null) {
                this.setRequest(request);
                return this.success();
            }
        }
        catch (MultipleLocationsException mle) {
            return this.failure(true);
        }
        catch (UnableToSetRequestException utsre) {
            return this.failure(true);
        }
        return this.failure(false);
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
        if (!this.isSet) {
            this.resolveAgainstClass(e.referenceType());
        }
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }
}

