/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.ExpressionGettingRequest;

public class KillRequest
extends ExpressionGettingRequest {
    private String threadName;

    public KillRequest(Debugger debugger, String threadName, String valueRep) {
        super(debugger, valueRep);
        this.threadName = threadName;
    }

    public Object go() throws NoVMException, DebuggerException {
        Value value = this.getValue();
        if (!(value instanceof ObjectReference)) {
            throw new DebuggerException("the <expr> must be an object");
        }
        ObjectReference oref = (ObjectReference)value;
        ThreadReference threadRef = this.debugger.getThread(this.threadName);
        try {
            threadRef.stop(oref);
        }
        catch (InvalidTypeException ite) {
            throw new DebuggerException(ite);
        }
        return threadRef;
    }
}

