/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.PathSearchingVirtualMachine;
import java.util.List;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.Request;

public class ClasspathRequest
extends Request {
    public ClasspathRequest(Debugger debugger) {
        super(debugger);
    }

    public Object go() throws NoVMException, DebuggerException {
        if (this.vm() instanceof PathSearchingVirtualMachine) {
            PathSearchingVirtualMachine pvm = (PathSearchingVirtualMachine)this.vm();
            return new Package(pvm.baseDirectory(), pvm.classPath());
        }
        throw new DebuggerException("The VM cannot search for a classpath");
    }

    public static class Package {
        public String baseDirectory;
        public List paths;

        public Package(String baseDirectory, List paths) {
            this.baseDirectory = baseDirectory;
            this.paths = paths;
        }
    }
}

