/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import org.aspectj.debugger.base.ClassListener;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.TextPrintingRequest;

public class ClassTextPrintingRequest
extends TextPrintingRequest
implements ClassListener {
    public static final int PREPARE = 1;
    public static final int UNLOAD = 16;
    public static final int PREPARE_OR_UNLOAD = 17;
    protected int mode;
    protected String className;

    public ClassTextPrintingRequest(Debugger debugger, String className, int mode, String text) {
        super(debugger, text);
        if (mode < 1 || mode > 17) {
            throw new IllegalArgumentException("mode:" + mode + " where " + 1 + "<=mode<=" + 17);
        }
        this.mode = mode;
        this.className = className;
    }

    public Object go() throws NoVMException, DebuggerException {
        this.debugger.addClassListener(this);
        return this.text;
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
        if ((this.mode & 1) != 0 && e.referenceType().name().equals(this.className)) {
            this.print();
        }
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
        if ((this.mode & 0x10) != 0 && e.className().equals(this.className)) {
            this.print();
        }
    }
}

