/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.request;

import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.Field;
import com.sun.jdi.ReferenceType;
import java.util.List;
import org.aspectj.debugger.base.AmbiguousClassException;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.InvalidClassException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.request.RequestAction;

public abstract class ClassAndFieldNeedingRequestAction
extends RequestAction {
    protected String className;
    protected String fieldName;

    public ClassAndFieldNeedingRequestAction(Debugger debugger, String className, String fieldName) {
        super(debugger);
        this.className = className;
        this.fieldName = fieldName;
    }

    protected Field getField() throws NoVMException, DebuggerException {
        try {
            return this.getReferenceType().fieldByName(this.fieldName);
        }
        catch (ClassNotPreparedException cnpe) {
            throw new DebuggerException(cnpe);
        }
    }

    protected ReferenceType getReferenceType() throws NoVMException, DebuggerException {
        List<ReferenceType> refTypes = this.vm().classesByName(this.className);
        if (refTypes.size() == 0) {
            throw new InvalidClassException(this.className);
        }
        if (refTypes.size() > 1) {
            throw new AmbiguousClassException(this.className, refTypes);
        }
        return refTypes.get(0);
    }

    public String getClassName() {
        return this.className;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public boolean equals(Object other) {
        if (other == null || !(other instanceof ClassAndFieldNeedingRequestAction)) {
            return super.equals(other);
        }
        ClassAndFieldNeedingRequestAction ra = (ClassAndFieldNeedingRequestAction)other;
        return this.getClassName().equals(ra.getClassName()) && this.getFieldName().equals(ra.getFieldName());
    }

    public String toString() {
        return this.getClassName() + "." + this.getFieldName();
    }
}

