/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Field;
import com.sun.jdi.LocalVariable;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Iterator;
import java.util.List;
import javax.swing.JScrollPane;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.gui.AJPanel;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.AJValueNodeFactory;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.VariablesRootTreeNode;
import org.aspectj.debugger.gui.VariablesTree;

public class VariablesTreePane
extends AJPanel
implements StopListener {
    private VariablesTree tree = null;

    public VariablesTreePane(Frame frame, GUIDebugger guid) {
        super(guid);
        this.debugger().addStopListener(this);
        this.setLayout(new BorderLayout());
        this.tree = new VariablesTree(frame);
        this.add((Component)new JScrollPane(this.tree), "Center");
    }

    public void accessWatchpointEvent(AccessWatchpointEvent e) {
        this.updateLocals();
    }

    public void breakpointEvent(BreakpointEvent e) {
        this.updateLocals();
    }

    public void exceptionEvent(ExceptionEvent e) {
        this.updateLocals();
    }

    public void modificationWatchpointEvent(ModificationWatchpointEvent e) {
        this.updateLocals();
    }

    public void stepEvent(StepEvent e) {
        this.updateLocals();
    }

    private DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.tree.getModel().getRoot();
    }

    private void newRoot() {
        this.model().setRoot(new VariablesRootTreeNode());
    }

    private DefaultTreeModel model() {
        return (DefaultTreeModel)this.tree.getModel();
    }

    private void updateLocals() {
        this.newRoot();
        List locals = this.debugger().locals();
        Iterator<Object> iter = locals.iterator();
        while (iter.hasNext()) {
            try {
                this.add(AJValueNodeFactory.make((LocalVariable)iter.next(), this.debugger.getDefaultFrame()));
            }
            catch (Exception e) {
                AJUtil.ex(e);
            }
        }
        try {
            ObjectReference oref = this.debugger().getDefaultThisObject();
            ReferenceType refType = this.debugger().getDefaultFrame().location().declaringType();
            List<Field> fields = refType.fields();
            iter = fields.iterator();
            while (iter.hasNext()) {
                Field field = (Field)iter.next();
                if (!this.shouldAddField(field)) continue;
                if (oref != null) {
                    this.add(AJValueNodeFactory.make(oref, field));
                    continue;
                }
                if (!field.isStatic()) continue;
                this.add(AJValueNodeFactory.make(refType, field));
            }
        }
        catch (Exception e) {
            AJUtil.ex(e);
        }
        this.tree.expandRow(0);
    }

    private boolean shouldAddField(Field field) {
        return field != null && field.name().indexOf("$ajc") == -1;
    }

    private void add(MutableTreeNode node) {
        boolean expand = this.getRoot().getChildCount() == 0;
        this.getRoot().add(node);
    }

    public static String d() {
        return "Variables Tree Pane";
    }

    public String toString() {
        return VariablesTreePane.d();
    }
}

