/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.basic.BasicTableUI;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AJStackFrameFormatter;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.StackTable;

class StackTable
extends JTable {
    public StackTable(TableModel model) {
        super(model);
        this.setUI(new StackTableUI());
    }

    public void setModel(TableModel model) {
        super.setModel(model);
        TableColumn col = this.getColumnModel().getColumn(0);
        int charWidth = 10;
        col.setWidth(4 * charWidth);
        col.setMinWidth(3 * charWidth);
        col.setMaxWidth(5 * charWidth);
    }

    class StackTableUI
    extends BasicTableUI {
        StackTableUI() {
        }

        protected MouseInputListener createMouseInputListener() {
            return new BasicTableUI.MouseInputHandler(this){
                private final /* synthetic */ StackTableUI this$1;
                {
                    this.this$1 = this$1;
                }

                public void mouseClicked(MouseEvent e) {
                    int row = StackTableUI.access$000(this.this$1).getSelectedRow();
                    int col = StackTableUI.access$000(this.this$1).getSelectedColumn();
                    int x = e.getX();
                    int y = e.getY();
                    AJStackFrameFormatter.MethodAndSource ms = (AJStackFrameFormatter.MethodAndSource)StackTableUI.access$000(this.this$1).getModel().getValueAt(row, 1);
                    if (!ms.isValid()) {
                        return;
                    }
                    String s = ms.getFullPath();
                    int l = ms.lineNumber;
                    if (SwingUtilities.isRightMouseButton(e) || SwingUtilities.isMiddleMouseButton(e)) {
                        JPopupMenu popup = new JPopupMenu();
                        String source = AJLineMapper.removeRoot(s);
                        JMenuItem item = new JMenuItem("Set breakpoint");
                        popup.add(item);
                        String cmd = "stop on " + source + ":" + l;
                        item.addActionListener(new ActionListener(this, l){
                            private final /* synthetic */ int val$l;
                            private final /* synthetic */ 1 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$l = val$l;
                            }

                            public void actionPerformed(ActionEvent _) {
                                Integer n = new Integer(this.val$l);
                            }
                        });
                        popup.show(StackTableUI.access$000(this.this$1), x + popup.getWidth() / 2, y + popup.getHeight() / 2);
                    } else if (e.getClickCount() == 2) {
                        ComponentRepository.getSourcePane().showSourceForFileAndLine(s, l);
                    }
                }
            };
        }

        static /* synthetic */ StackTable access$000(StackTableUI x0) {
            return x0.StackTable.this;
        }
    }
}

