/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.aspectj.debugger.base.ErrorLogger;
import org.aspectj.debugger.gui.AJCClassNode;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJTreeCellRenderer;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.ClassNode;
import org.aspectj.debugger.gui.ClassNodeMouseListener;
import org.aspectj.debugger.gui.ClassNodeSelectionListener;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.Dialogs;
import org.aspectj.debugger.gui.GUIDebugger;

public class SourceTreePane
extends JPanel {
    private AbstractSourcePane sourcePane;
    private JTree tree;
    protected GUIDebugger guiDebugger;

    public SourceTreePane(GUIDebugger guiDebugger, AbstractSourcePane sourcePane) {
        super(new BorderLayout());
        this.sourcePane = sourcePane;
        this.guiDebugger = guiDebugger;
        this.tree = new JTree();
        this.setRoot(sourcePane.getSourcePath());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addMouseListener(new SourceTreePaneMouseListener(this.tree));
        this.tree.addTreeSelectionListener(new ClassNodeSelectionListener(guiDebugger));
        this.tree.setCellRenderer(new AJTreeCellRenderer());
        JScrollPane treeView = new JScrollPane(this.tree);
        this.add(treeView);
    }

    public void setRoot(String root) {
        this.tree.setModel(new DefaultTreeModel(new RootNode(new File(root))));
    }

    private void showRunMenu(int x, int y, final String pathString) {
        this.showMenu(x, y, new AbstractAction("Debug class " + pathString){

            public void actionPerformed(ActionEvent e) {
                ComponentRepository.getGUIDebugger().executeCommand("run " + pathString);
            }
        });
    }

    private void showUseMenu(int x, int y) {
        this.showMenu(x, y, new AbstractAction("Change the source path"){

            public void actionPerformed(ActionEvent e) {
                Dialogs.showUseDialog();
            }
        });
    }

    private void showMenu(int x, int y, AbstractAction a) {
        JPopupMenu menu = new JPopupMenu();
        menu.add(a);
        menu.show(this.tree, x, y);
    }

    void showSourceFile(String relativePath) {
        this.sourcePane.showSource(relativePath);
    }

    public static String d() {
        return "Source Tree Pane";
    }

    public String toString() {
        return SourceTreePane.d();
    }

    class SourceTreePaneMouseListener
    extends ClassNodeMouseListener {
        public SourceTreePaneMouseListener(JTree tree) {
            super(SourceTreePane.this.guiDebugger, tree);
        }

        public void mouseClicked(MouseEvent e) {
            int x = e.getX();
            int y = e.getY();
            int selRow = this.tree().getRowForLocation(x, y);
            TreePath selPath = this.tree().getPathForLocation(x, y);
            if (selPath == null) {
                return;
            }
            AJTreeNode node = (AJTreeNode)selPath.getLastPathComponent();
            if (node instanceof FileNode) {
                node.mouseEvent(e);
                return;
            }
            super.mouseClicked(e);
        }
    }

    class SourceTreeModel
    implements TreeModel {
        private String root;

        public SourceTreeModel(String root) {
            this.root = root;
        }

        public void addTreeModelListener(TreeModelListener l) {
        }

        public void removeTreeModelListener(TreeModelListener l) {
        }

        public void valueForPathChanged(TreePath path, Object newValue) {
        }

        public Object getChild(Object parent, int index) {
            if (parent instanceof File) {
                return this.getChildren((File)parent)[index];
            }
            return null;
        }

        public int getChildCount(Object parent) {
            if (parent instanceof File) {
                return this.getChildren((File)parent).length;
            }
            return -1;
        }

        public int getIndexOfChild(Object parent, Object child) {
            if (parent instanceof File) {
                return this.getIndexOfChild(this.getChildren((File)parent), child);
            }
            return -1;
        }

        private int getIndexOfChild(File[] kids, Object child) {
            int i = 0;
            while (i < kids.length) {
                if (kids[i].equals(child)) {
                    return i;
                }
                ++i;
            }
            return -1;
        }

        public Object getRoot() {
            return SourceTreePane.this.sourcePane.getSourceManager().getFile(this.root);
        }

        public boolean isLeaf(Object node) {
            return !((File)node).isDirectory();
        }

        private ClassNode[] getClassNodes(File file) {
            try {
                return AJCClassNode.makeNodes(file.getCanonicalPath());
            }
            catch (IOException iOException) {
                return new ClassNode[0];
            }
        }

        private File[] getChildren(File file) {
            File[] files;
            File[] dirs = file.listFiles(new FilenameFilter(this){
                private final /* synthetic */ SourceTreeModel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory();
                }
            });
            File[] javaFiles = file.listFiles(new FilenameFilter(this){
                private final /* synthetic */ SourceTreeModel this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return name.endsWith(".java");
                }
            });
            if (javaFiles == null || dirs == null) {
                files = new File[]{};
            } else {
                files = new File[dirs.length + javaFiles.length];
                System.arraycopy(dirs, 0, files, 0, dirs.length);
                System.arraycopy(javaFiles, 0, files, dirs.length, javaFiles.length);
            }
            return files;
        }
    }

    class FileNode
    extends AJTreeNode {
        protected File file;

        public FileNode(File file) {
            this.file = file;
            this.setUserObject(this.file);
            if (file != null) {
                if (file.isDirectory()) {
                    this.addFiles();
                } else if (!SourceTreePane.this.guiDebugger.getDebugger().getOptions().isSet("noajcclasses")) {
                    this.addClasses();
                }
            }
        }

        public int getType() {
            if (this.file.isDirectory()) {
                return AJIcons.FOLDER_ICON;
            }
            return AJIcons.DOCUMENT_ICON;
        }

        private void addFiles() {
            File[] files;
            File[] dirs = this.file.listFiles(new FilenameFilter(this){
                private final /* synthetic */ FileNode this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return new File(dir, name).isDirectory();
                }
            });
            File[] javaFiles = this.file.listFiles(new FilenameFilter(this){
                private final /* synthetic */ FileNode this$1;
                {
                    this.this$1 = this$1;
                }

                public boolean accept(File dir, String name) {
                    return name.endsWith(".java");
                }
            });
            if (javaFiles == null || dirs == null) {
                files = new File[]{};
            } else {
                files = new File[dirs.length + javaFiles.length];
                System.arraycopy(dirs, 0, files, 0, dirs.length);
                System.arraycopy(javaFiles, 0, files, dirs.length, javaFiles.length);
            }
            this.addFiles(files);
        }

        private void addFiles(File[] files) {
            int i = 0;
            while (i < files.length) {
                this.add(new FileNode(files[i]));
                ++i;
            }
        }

        private void addClasses() {
            try {
                String fullName;
                try {
                    fullName = this.file.getCanonicalPath();
                }
                catch (IOException e) {
                    fullName = this.file.getAbsolutePath();
                }
                if (fullName == null) {
                    return;
                }
                AJCClassNode[] nodes = AJCClassNode.makeNodes(fullName);
                int i = 0;
                while (i < nodes.length) {
                    this.add(nodes[i]);
                    ++i;
                }
            }
            catch (Throwable t) {
                new ErrorLogger(ComponentRepository.getAJDebugger()).log(t);
            }
        }

        public void leftMouseButton(MouseEvent e) {
            String fullName;
            try {
                fullName = this.file.getCanonicalPath();
            }
            catch (IOException ee) {
                fullName = this.file.getAbsolutePath();
            }
            String relativePath = ComponentRepository.getAJDebugger().removeSourcePath(fullName);
            SourceTreePane.this.showSourceFile(relativePath);
        }

        public void rightMouseButton(MouseEvent e) {
            String name = this.file.getName();
            int ijava = name.indexOf(".java");
            if (ijava != -1) {
                name = name.substring(0, ijava);
            }
            String title = "run class " + name;
            String runCommand = "run " + name;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    class RootNode
    extends FileNode {
        public RootNode(File file) {
            super(file);
        }

        public String toString() {
            return this.file + "";
        }

        public void rightMouseButton(MouseEvent e) {
            SourceTreePane.this.showUseMenu(e.getX(), e.getY());
        }
    }
}

