/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.event.ClassUnloadEvent;
import com.sun.jdi.event.VMStartEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;
import org.aspectj.debugger.base.ClassListener;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.ClassBreakpointRequestAction;
import org.aspectj.debugger.request.ClassMethodBreakpointRequestAction;
import org.aspectj.debugger.request.Request;
import org.aspectj.tools.ide.SourceLine;

public class SourcePane
extends AbstractSourcePane
implements ClassListener {
    private HashMap models = new HashMap();
    private final Font font = new Font("monospaced", 0, 10);
    private JScrollPane scrollPane;
    private JList jlist;
    private TitlePanel titlePanel = new TitlePanel();

    public SourcePane(GUIDebugger guid) {
        super(guid);
        this.jlist = new JList(new DefaultListModel());
        this.jlist.setCellRenderer(new SourcePaneCellRenderer());
        this.jlist.addMouseListener(new SourcePaneMouseListener());
        this.jlist.setFont(this.font);
        this.scrollPane = new JScrollPane(this.jlist);
        this.add(this.scrollPane);
        this.add((Component)this.titlePanel, "South");
        guid.getDebugger().addClassListener(this);
    }

    public boolean showSource(String relativePath) {
        SourceListModel model = this.getModel(relativePath);
        if (model == null) {
            return false;
        }
        this.setModel(model);
        this.titlePanel.setTitle(relativePath);
        return true;
    }

    public void showLineForCurrentModel(int line, boolean isAtBreakpoint) {
        if (line > 0 && line <= this.jlist.getModel().getSize()) {
            this.jlist.ensureIndexIsVisible(line - 1);
            this.jlist.ensureIndexIsVisible(line - 1 - 4);
            this.jlist.ensureIndexIsVisible(line - 1 + 4);
            this.jlist.setSelectedIndex(line - 1);
        }
    }

    public String getSourceName() {
        return ((SourceListModel)this.jlist.getModel()).getSourceName();
    }

    private void setModel(SourceListModel model) {
        if (model != null) {
            this.markLines(model);
            this.jlist.setModel(model);
        } else {
            System.out.println("Model is null");
        }
    }

    private SourceListModel getModel(ReferenceType refType) {
        SourceListModel model = null;
        model = (SourceListModel)this.models.get(refType);
        if (model != null) {
            return model;
        }
        try {
            String sourceName = this.debugger().sourceName(refType);
            model = this.getModel(sourceName);
            if (model != null) {
                this.models.put(refType, model);
                return model;
            }
            String strippedSourceName = this.debugger().strip(sourceName);
            model = this.getModel(strippedSourceName);
            if (model != null) {
                this.models.put(sourceName, model);
                this.models.put(refType, model);
                return model;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            // empty catch block
        }
        return null;
    }

    private SourceListModel getModel(Request request) {
        if (request instanceof ClassMethodBreakpointRequestAction) {
            ClassMethodBreakpointRequestAction ba = (ClassMethodBreakpointRequestAction)request;
            return this.getModel(ba.getSourceName());
        }
        if (request instanceof ClassBreakpointRequestAction) {
            ClassBreakpointRequestAction ba = (ClassBreakpointRequestAction)request;
            String className = ba.getClassName();
            SourceListModel model = (SourceListModel)this.models.get(className);
            if (model != null) {
                return model;
            }
            try {
                Iterator<ReferenceType> iter = this.debugger().getVM().allClasses().iterator();
                while (iter.hasNext()) {
                    ReferenceType refType = iter.next();
                    if (!className.equals(refType.name()) || (model = this.getModel(refType)) == null) continue;
                    return model;
                }
            }
            catch (NoVMException nvme) {}
        } else if (request instanceof BreakpointRequestAction) {
            SourceLine sl = this.debugger.getSourceLine((BreakpointRequestAction)request);
            return this.getModel(sl.filename);
        }
        return null;
    }

    private SourceListModel getModel(String relativePath) {
        if (relativePath == null || relativePath.equals("<not-available>")) {
            return null;
        }
        String oldRelativePath = relativePath;
        relativePath = this.guid().getDebugger().removeSourcePath(relativePath);
        SourceListModel model = (SourceListModel)this.models.get(relativePath);
        if (model != null) {
            return model;
        }
        List lines = this.debugger.getSourceManager().getSourceLines(relativePath);
        if (lines != null) {
            model = new SourceListModel(lines, relativePath);
            this.models.put(relativePath, model);
            this.models.put(oldRelativePath, model);
            String fullPath = AJLineMapper.getFullFileNameFromFile(relativePath, false).toLowerCase();
            this.models.put(fullPath, model);
        }
        return model;
    }

    private void markLines(SourceListModel model) {
        try {
            Iterator<ReferenceType> iter = this.debugger().getVM().allClasses().iterator();
            while (iter.hasNext()) {
                ReferenceType refType = iter.next();
                try {
                    String sourceName = this.debugger().sourceName(refType);
                    if (!sourceName.equals(model.getSourceName())) continue;
                    model.markLines(refType);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        catch (NoVMException nvme) {
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    public void requestSet(String filename, int line, BreakpointRequestAction ba) {
        SourceListModel model = this.getModel(filename);
        if (model != null) {
            model.verifyBreakpoint(line, ba);
        }
    }

    public void requestClear(String filename, int line, BreakpointRequestAction ba) {
        SourceListModel model = this.getModel(ba);
        if (model != null) {
            model.clearBreakpoint(line);
        }
    }

    public void requestDeferred(String filename, int line, BreakpointRequestAction ba) {
        SourceListModel model = this.getModel(ba);
        if (model != null) {
            model.unverifyBreakpoint(line, ba);
        }
    }

    public void vmStartEvent(VMStartEvent e) {
        try {
            Iterator<ReferenceType> iter = this.debugger.getVM().allClasses().iterator();
            while (iter.hasNext()) {
                ReferenceType refType = iter.next();
                SourceListModel model = this.getModel(refType);
                if (model == null) continue;
                model.markLines(refType);
            }
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }

    public void classPrepareEvent(ClassPrepareEvent e) {
        SourceListModel model = this.getModel(e.referenceType());
        if (model != null) {
            model.markLines(e.referenceType());
        }
    }

    public void classUnloadEvent(ClassUnloadEvent e) {
    }

    class SourceListModel
    extends AbstractListModel
    implements SourceManager.LineUpdatable {
        private List lines;
        private String sourceName;

        public SourceListModel(List lines, String sourceName) {
            this.lines = lines;
            this.sourceName = sourceName;
            this.setUpdater(lines);
        }

        public void update(int line) {
            this.fireContentsChanged(this, line, line);
        }

        public int getSize() {
            return this.lines.size();
        }

        public void setExecutable(int line, String className) {
            this.line(line).ex(className);
            this.update(line);
        }

        public void verifyBreakpoint(int line, BreakpointRequestAction request) {
            this.line(line).verify(request);
            this.update(line);
        }

        public void unverifyBreakpoint(int line, BreakpointRequestAction request) {
            this.line(line).unverify(request);
            this.update(line);
        }

        public void clearBreakpoint(int line) {
            this.line(line).clear();
            this.update(line);
        }

        SourceManager.SourceLine line(int line) {
            return (SourceManager.SourceLine)this.getElementAt(line - 1);
        }

        public String getSourceName() {
            return this.sourceName;
        }

        public Object getElementAt(int index) {
            SourceManager.SourceLine line = SourceManager.SourceLine.emptyLine;
            try {
                line = (SourceManager.SourceLine)this.lines.get(index);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            return line;
        }

        public boolean equals(Object other) {
            if (!(other instanceof SourceListModel)) {
                return super.equals(other);
            }
            SourceListModel model = (SourceListModel)other;
            return this.getSourceName().equals(model.getSourceName());
        }

        public void markLines(ReferenceType refType) {
        }

        private void setUpdater(List lines) {
            Iterator iter = lines.iterator();
            while (iter.hasNext()) {
                ((SourceManager.SourceLine)iter.next()).setUpdater(this);
            }
        }

        public String toString() {
            return this.sourceName + ":" + (this.lines != null ? this.lines.size() : -1);
        }
    }

    class SourcePaneCellRenderer
    extends DefaultListCellRenderer {
        private final Font font = new Font("monospaced", 0, 10);
        private final Color BLUE = Color.blue.darker();
        private final Color RED = Color.red.darker();

        SourcePaneCellRenderer() {
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            SourceManager.SourceLine sl = (SourceManager.SourceLine)value;
            if (sl.getStatus() == 0 && sl.isExecutable()) {
                this.setIcon(AJIcons.getIcon(AJIcons.EXECUTABLE_ICON));
            } else {
                switch (sl.getStatus()) {
                    case 0: {
                        this.setIcon(AJIcons.getIcon(AJIcons.BLANK_ICON));
                        break;
                    }
                    case 1: {
                        this.setIcon(AJIcons.getIcon(AJIcons.UNVERIFIED_BREAKPOINT_ICON));
                        break;
                    }
                    case 2: {
                        this.setIcon(AJIcons.getIcon(AJIcons.VERIFIED_BREAKPOINT_ICON));
                    }
                }
            }
            String str = this.shrink(SourcePane.this.guid().getDebugger().sourceLine(sl));
            this.setText(str);
            return this;
        }

        public Font getFont() {
            return this.font;
        }

        private String shrink(String str) {
            return str.trim();
        }
    }

    class SourcePaneMouseListener
    extends MouseAdapter {
        SourcePaneMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            this.popup(e);
        }

        private void popup(MouseEvent e) {
            JList jlist = (JList)e.getSource();
            int x = e.getX();
            int y = e.getY();
            SourceManager.SourceLine sl = (SourceManager.SourceLine)jlist.getSelectedValue();
            if (SwingUtilities.isMiddleMouseButton(e) || SwingUtilities.isRightMouseButton(e)) {
                this.show(jlist, sl, x, y);
            }
        }

        private void show(JList jlist, SourceManager.SourceLine sl, int x, int y) {
            if (sl == null) {
                System.out.println("sl = null");
                return;
            }
            BreakpointRequestAction req = sl.getRequest();
            if (req != null) {
                System.out.println("request=" + req.getProto());
            }
            String sourceName = sl.getSourceName();
            int line = jlist.getSelectedIndex() + 1;
            JPopupMenu popup = new JPopupMenu();
            switch (sl.getStatus()) {
                case 0: {
                    popup.add(this.item("stop at " + sourceName + ":" + line, "stop at line " + line));
                    break;
                }
                case 1: 
                case 2: {
                    popup.add(this.item("clear " + req.getProto(), "clear " + req.getProto()));
                }
            }
            popup.show(jlist, x + popup.getWidth() / 2, y + popup.getHeight() / 2);
        }

        private JMenuItem item(String setString, String titleString) {
            JMenuItem item = new JMenuItem(titleString);
            item.addActionListener(new ActionListener(this, setString){
                private final /* synthetic */ String val$setString;
                private final /* synthetic */ SourcePaneMouseListener this$1;
                {
                    this.this$1 = this$1;
                    this.val$setString = val$setString;
                }

                public void actionPerformed(ActionEvent e) {
                    SourcePaneMouseListener.access$000((SourcePaneMouseListener)this.this$1).debugger.execute(this.val$setString);
                }
            });
            return item;
        }

        static /* synthetic */ SourcePane access$000(SourcePaneMouseListener x0) {
            return x0.SourcePane.this;
        }
    }

    class TitlePanel
    extends JPanel {
        private JLabel label = new JLabel();

        public TitlePanel() {
            this.setLayout(new FlowLayout());
            this.add(new JLabel("Source: "));
            this.add(this.label);
        }

        public void setTitle(String str) {
            this.set(str);
        }

        public void loading(String str) {
            this.set("Loading..." + str);
        }

        private void set(String str) {
            String relativePath = str;
            int i = relativePath.length() - 1;
            while (i >= 0) {
                char c = relativePath.charAt(i);
                if (c == File.pathSeparatorChar || c == '\\' || c == '/') break;
                --i;
            }
            if (i > -1 && i < relativePath.length() - 1) {
                relativePath = relativePath.substring(i + 1);
            }
            this.label.setText(relativePath);
        }
    }
}

