/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.LocatableEvent;
import java.util.List;
import java.util.Vector;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.ConnectFrame;
import org.aspectj.debugger.tty.CommandLineDebugger;

public class GUIDebugger
extends CommandLineDebugger {
    private static final String[] emptyArgs = new String[0];
    private ComponentDirector gui;

    protected GUIDebugger() {
        this(emptyArgs);
    }

    protected GUIDebugger(String[] args) {
        super(args, false);
    }

    public GUIDebugger(ComponentDirector gui, String[] args) {
        super(args, false);
        this.setGui(gui);
    }

    public boolean isGUI() {
        return true;
    }

    public ComponentDirector getGui() {
        return this.gui;
    }

    public void setGui(ComponentDirector gui) {
        this.gui = gui;
    }

    public String getClassNameToRun() {
        return null;
    }

    public String getClasspath() {
        return null;
    }

    public String getVMParameters() {
        return null;
    }

    public void viewCommand(String sourceName, List sourceLines) throws NoVMException, DebuggerException {
        ComponentRepository.getSourcePane().showSource(sourceName);
    }

    public void whereCommand(String threadName, List frames) throws NoVMException, DebuggerException {
        if (frames == null || frames.size() == 0) {
            return;
        }
        StackFrame frame = (StackFrame)frames.get(0);
        if (frame == null) {
            return;
        }
        this.expand(frame);
        ComponentRepository.getSourcePane().showSourceForFrame(frame, false);
        ThreadReference threadRef = this.getDebugger().getThread(threadName);
        ComponentRepository.getStackTablePane().showForThread(threadRef);
    }

    public void localsCommand(List locals) throws NoVMException, DebuggerException {
        super.localsCommand(locals);
        this.expandToLocals();
    }

    public void printCommand(Object valueRep, Value value) throws NoVMException, DebuggerException {
        super.printCommand(valueRep, value);
        this.expandToValue(value, valueRep);
    }

    public void dumpCommand(Object valueRep, Value value) throws NoVMException, DebuggerException {
        super.dumpCommand(valueRep, value);
        this.expandToValue(value, valueRep);
    }

    public void evalCommand(Object valueRep, Value value) throws NoVMException, DebuggerException {
        super.evalCommand(valueRep, value);
        this.expandToValue(value, valueRep);
    }

    public void listCommand(List sourceLines) throws NoVMException, DebuggerException {
        if (sourceLines.size() == 0) {
            return;
        }
        SourceManager.SourceLine slFirst = (SourceManager.SourceLine)sourceLines.get(0);
        SourceManager.SourceLine slLast = (SourceManager.SourceLine)sourceLines.get(sourceLines.size() - 1);
        String sourceName = slFirst.getSourceName();
        int first = slFirst.getLineNumber();
        int last = slLast.getLineNumber();
        if (first > 0 && last > 0) {
            int middle = first;
            ComponentRepository.getSourcePane().showSourceForFileAndLine(sourceName, middle);
        } else {
            ComponentRepository.getSourcePane().showSource(sourceName);
        }
    }

    public void listCommand(String sourceName, List sourceLines) throws NoVMException, DebuggerException {
        this.listCommand(sourceLines);
    }

    public void listCommand(String sourceName, int lineNumber, SourceManager.SourceLine sl) throws NoVMException, DebuggerException {
        Vector<SourceManager.SourceLine> sourceLines = new Vector<SourceManager.SourceLine>();
        sourceLines.add(sl);
        this.listCommand(sourceLines);
    }

    public void listCommand(String sourceName, int startLine, int endLine, List sourceLines) throws NoVMException, DebuggerException {
        this.listCommand(sourceLines);
    }

    public void useCommand(String sourcePath, String newSourcePath) throws NoVMException, DebuggerException {
        super.useCommand(sourcePath, newSourcePath);
    }

    public void connectCommand(VirtualMachine vm) throws NoVMException, DebuggerException {
        if (vm != null) {
            this.result("Connected to " + vm.name());
        }
    }

    private void expand(LocatableEvent e) {
        try {
            this.expand(e.thread().frame(0));
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            // empty catch block
        }
    }

    private void expand(StackFrame frame) {
        ComponentRepository.getThreadGroupTreePane().expandToFrame(frame);
    }

    private void expandToLocals() {
        try {
            ComponentRepository.getThreadGroupTreePane().expandToLocals(this.getDebugger().getDefaultFrame());
        }
        catch (NoVMException noVMException) {
            // empty catch block
        }
    }

    private void expandToValue(Value value, Object valueRep) {
        ComponentRepository.getThreadGroupTreePane().expandToValue(value, valueRep + "");
    }

    public boolean wantsToExit() {
        return false;
    }

    public void exit() {
        this.gui.shutDown();
        this.debugger.shutDown();
        super.exit();
    }

    public boolean canRestart() {
        return true;
    }

    public static String d() {
        return "GUI Debugger";
    }

    public String toString() {
        return GUIDebugger.d();
    }

    public VirtualMachine connect(String vmArgs, String className, String commandLine) {
        return ConnectFrame.vm(this, vmArgs, className, commandLine);
    }
}

