/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.tree.TreePath;
import org.aspectj.debugger.gui.FilePane;
import org.aspectj.util.gui.CenteredJDialog;

class FileFrame
extends CenteredJDialog {
    JLabel label;
    FilePane filePane;
    JTextField text;
    JButton setButton;
    JScrollPane scroller;
    JPanel panel = new JPanel();

    public FileFrame() {
        this((String)null);
    }

    public FileFrame(String root) {
        super((Frame)null, "FileFrame", false);
        this.panel.setLayout(new BorderLayout());
        this.label = new JLabel("Please set the source path");
        this.filePane = new FilePane(root);
        this.filePane.setPreferredSize(new Dimension(200, 100));
        this.scroller = new JScrollPane(this.filePane);
        this.text = new JTextField(30);
        this.setButton = new JButton("Set");
        this.setButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent _) {
                FileFrame.this.set();
            }
        });
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(this.text);
        bottomPanel.add(this.setButton);
        this.panel.add((Component)this.label, "North");
        this.panel.add((Component)this.scroller, "Center");
        this.panel.add((Component)bottomPanel, "South");
        this.setDefaultCloseOperation(2);
        this.getContentPane().add(this.panel);
    }

    void set() {
        TreePath path = this.filePane.tree().getSelectionPath();
        if (path == null) {
            this.msg("You must select a directory");
        }
        File file = (File)path.getLastPathComponent();
        while (file != null && !file.isDirectory()) {
            file = file.getParentFile();
        }
        if (file == null) {
            System.out.println("Something funny");
            return;
        }
        this.text.setText(file + "");
    }

    void msg(String s) {
        System.out.println(s);
    }
}

