/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.VirtualMachine;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.base.Modes;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJMenuBar;
import org.aspectj.debugger.gui.AJThreadGroupTreePane;
import org.aspectj.debugger.gui.AJToolBar;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.BreakpointTreePane;
import org.aspectj.debugger.gui.ColorChangingLabel;
import org.aspectj.debugger.gui.CommandLine;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.gui.EnvTextArea;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.OutputTextArea;
import org.aspectj.debugger.gui.SourcePane;
import org.aspectj.debugger.gui.StackTablePane;
import org.aspectj.debugger.gui.VariablesTreePane;
import org.aspectj.debugger.gui.WatchpointTreePane;

public class ComponentRepository {
    private static StackTablePane stackTablePane = null;
    private static CommandLine commandLine = null;
    private static OutputTextArea outputTextArea = null;
    private static EnvTextArea envTextArea = null;
    private static AbstractSourcePane sourcePane = null;
    private static AJThreadGroupTreePane threadGroupTreePane = null;
    private static BreakpointTreePane breakpointTreePane = null;
    private static ComponentDirector gui = null;
    private static AJToolBar toolbar = null;
    private static AJMenuBar menuBar = null;
    private static ColorChangingLabel statusLabel = null;
    private static GUIDebugger guiDebugger = null;
    private static AJDebugger debugger = null;
    private static WatchpointTreePane watchpointTreePane = null;
    private static VariablesTreePane variablesTreePane = null;
    static boolean debug = false;
    private static String[] tasks = null;
    private static final int LAGER_WIDTH = 300;
    private static final int LAGER_HEIGHT = 30;
    private static Lager lager;

    static void db(Object o) {
        if (debug) {
            System.err.println("<DEBUG> " + o);
        }
    }

    private static void initTasks() {
        tasks = new String[]{AJIcons.d(), GUIDebugger.d(), AJDebugger.d(), OutputTextArea.d(), StackTablePane.d(), CommandLine.d(), EnvTextArea.d(), AbstractSourcePane.d(), AJThreadGroupTreePane.d(), BreakpointTreePane.d(), WatchpointTreePane.d(), VariablesTreePane.d(), AJToolBar.d(), AJMenuBar.d(), ComponentDirector.d()};
    }

    private static void startLogging() {
        lager.start();
    }

    private static void doneLogging() {
        lager.done();
    }

    private static void task() {
        lager.log(null);
    }

    private static boolean ide() {
        return Modes.isIde();
    }

    public static final void init(ComponentDirector gui, GUIDebugger _guiDebugger, AbstractSourcePane _sourcePane, boolean _debug) {
        ComponentRepository.startLogging();
        debug = _debug;
        ComponentRepository.task();
        AJIcons.init();
        ComponentRepository.task();
        guiDebugger = _guiDebugger;
        guiDebugger.setGui(gui);
        ComponentRepository.task();
        debugger = guiDebugger.getDebugger();
        ComponentRepository.task();
        outputTextArea = new OutputTextArea(guiDebugger);
        gui.setPrintStream(outputTextArea.getPrintStream());
        ComponentRepository.task();
        stackTablePane = new StackTablePane(guiDebugger);
        ComponentRepository.task();
        commandLine = new CommandLine(gui);
        ComponentRepository.task();
        envTextArea = new EnvTextArea(guiDebugger);
        ComponentRepository.task();
        sourcePane = _sourcePane;
        ComponentRepository.task();
        threadGroupTreePane = new AJThreadGroupTreePane(guiDebugger);
        ComponentRepository.task();
        breakpointTreePane = new BreakpointTreePane(gui, guiDebugger);
        ComponentRepository.task();
        watchpointTreePane = new WatchpointTreePane(gui, guiDebugger);
        ComponentRepository.task();
        variablesTreePane = new VariablesTreePane(gui, guiDebugger);
        ComponentRepository.task();
        toolbar = new AJToolBar(guiDebugger);
        ComponentRepository.task();
        if (!ComponentRepository.ide()) {
            menuBar = new AJMenuBar(guiDebugger);
        }
        statusLabel = commandLine.getStatusLabel();
        ComponentRepository.task();
        ComponentRepository.gui = gui;
        ComponentRepository.doneLogging();
    }

    public static void init(ComponentDirector gui, GUIDebugger _guiDebugger, AbstractSourcePane _sourcePane) {
        ComponentRepository.init(gui, _guiDebugger, _sourcePane, false);
    }

    public static void init(ComponentDirector gui, String[] args) {
        GUIDebugger guid = new GUIDebugger(gui, args);
        ComponentRepository.init(gui, guid, new SourcePane(guid));
    }

    public static void execute(String cmd) {
        ComponentRepository.getGUIDebugger().executeCommand(cmd);
    }

    public static StackTablePane getStackTablePane() {
        return stackTablePane;
    }

    public static CommandLine getCommandLine() {
        return commandLine;
    }

    public static OutputTextArea getOutputTextArea() {
        return outputTextArea;
    }

    public static EnvTextArea getEnvTextArea() {
        return envTextArea;
    }

    public static AbstractSourcePane getSourcePane() {
        return sourcePane;
    }

    public static AJThreadGroupTreePane getThreadGroupTreePane() {
        return threadGroupTreePane;
    }

    public static BreakpointTreePane getBreakpointTreePane() {
        return breakpointTreePane;
    }

    public static Frame getFrame() {
        return gui;
    }

    public static ComponentDirector getComponentDirector() {
        return gui;
    }

    public static AJToolBar getToolBar() {
        return toolbar;
    }

    public static AJMenuBar getMenuBar() {
        return menuBar;
    }

    public static ColorChangingLabel getStatusLabel() {
        return statusLabel;
    }

    public static GUIDebugger getGUIDebugger() {
        return guiDebugger;
    }

    public static AJDebugger getAJDebugger() {
        return debugger;
    }

    public static VirtualMachine vm() throws NoVMException {
        return ComponentRepository.getAJDebugger().getVM();
    }

    public static WatchpointTreePane getWatchpointTreePane() {
        return watchpointTreePane;
    }

    public static VariablesTreePane getVariablesTreePane() {
        return variablesTreePane;
    }

    static {
        ComponentRepository.initTasks();
        lager = new Lager(tasks);
    }

    private static class Lager {
        private JLabel[] labels;
        private int[] times;
        private int task = 0;
        private static final Color defaultColor = new JLabel().getForeground();

        public Lager(String[] tasks) {
        }

        private JPanel panel() {
            JPanel p = new JPanel();
            p.setLayout(new BoxLayout(p, 1));
            p.setBorder(BorderFactory.createEtchedBorder());
            return p;
        }

        public void log(Object str) {
            ++this.task;
        }

        private void unhighlight(JLabel label) {
            Font f = label.getFont();
            f = new Font(f.getName(), 1, f.getSize());
            label.setFont(f);
            label.setForeground(defaultColor.darker());
        }

        private void highlight(JLabel label) {
            Font f = label.getFont();
            f = new Font(f.getName(), 3, f.getSize());
            label.setFont(f);
            label.setForeground(defaultColor.darker().darker().darker());
        }

        private boolean checkTask(int t) {
            return t > -1 && t < tasks.length;
        }

        public void start() {
            if (Modes.isJBuilder() || !Modes.isForte()) {
                // empty if block
            }
        }

        public void done() {
        }
    }
}

