/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.aspectj.debugger.gui.CommandLine;
import org.aspectj.debugger.gui.ComponentRepository;

class ColorChangingLabel
extends JPanel {
    private String text;
    private JLabel label;
    public static Color ON_COLOR = Color.red;
    public static Color OFF_COLOR = Color.green.darker().darker();
    public static int WIDTH = 170;

    ColorChangingLabel(String text) {
        this.text = text;
        this.label = new JLabel(text, 0);
        this.label.setPreferredSize(new Dimension(WIDTH, (int)this.label.getPreferredSize().getHeight()));
        this.turnOff();
        this.setLayout(new BoxLayout(this, 0));
        this.add(new JLabel("Status:"));
        this.add(this.label);
    }

    ColorChangingLabel() {
        this("Idle");
    }

    void turnOn() {
        this.label.setForeground(ON_COLOR);
        this.giveUpFocus();
    }

    void giveUpFocus() {
        CommandLine cl = ComponentRepository.getCommandLine();
        if (cl != null) {
            cl.requestFocus();
        }
    }

    void turnOn(String newText) {
        this.label.setText(newText);
        this.turnOn();
    }

    void turnOff(String newText) {
        if (newText == null) {
            this.label.setText(this.text);
        } else {
            this.label.setText(newText);
        }
        this.label.setForeground(OFF_COLOR);
        this.giveUpFocus();
    }

    void turnOff() {
        this.turnOff(this.text);
    }
}

