/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.tree.TreeNode;
import org.aspectj.debugger.gui.AJClassNode;
import org.aspectj.debugger.gui.AbstractSourcePane;
import org.aspectj.debugger.gui.ClassNodeFactory;
import org.aspectj.debugger.gui.ClassTreePane;
import org.aspectj.debugger.gui.MethodNode;
import org.aspectj.debugger.gui.NonAdvisableMethodNode;
import org.aspectj.debugger.gui.Sourceable;

public abstract class ClassNode
extends AJClassNode
implements Sourceable {
    public ClassNode(ReferenceType refType) {
        super(refType);
        this.setUserObject(refType);
    }

    protected ReferenceType refType() {
        return (ReferenceType)this.getUserObject();
    }

    protected void addMethod(Method method) {
        if (method.declaringType().equals(this.refType())) {
            NonAdvisableMethodNode methodNode = new NonAdvisableMethodNode(method);
            this.add(methodNode);
        } else {
            this.addToSuper(method);
        }
    }

    protected void addToSuper(Method method) {
        TreeNode treeNode = this.getChildAt(0);
        if (!(treeNode instanceof ClassNode)) {
            return;
        }
        ClassNode classNode = (ClassNode)treeNode;
        classNode.addMethod(method);
    }

    protected abstract String name();

    protected abstract String packageName();

    public String fullName() {
        String pname = this.packageName();
        String name = this.name();
        if (pname == null || pname.equals("")) {
            return name;
        }
        return pname + "." + name;
    }

    public String toString() {
        String name = this.name();
        if (this.getParent() instanceof ClassTreePane.PackageNode) {
            int idot = name.lastIndexOf(46);
            return idot != -1 ? name.substring(idot + 1) : name;
        }
        return name;
    }

    public String getToolTipText() {
        return this.kind() + " " + this.name();
    }

    protected abstract String kind();

    protected AJClassNode newClassNode(ReferenceType refType) {
        return ClassNodeFactory.classNode(refType);
    }

    public void showOnSource(AbstractSourcePane sourcePane) {
        sourcePane.showSourceForFileAndLine(this.getRelativePath(), this.getLine());
    }

    protected abstract String getRelativePath();

    protected abstract int getLine();

    public List getMethodStrings() {
        Vector<String> methodStrings = new Vector<String>();
        if (this.children == null) {
            return methodStrings;
        }
        Iterator iter = ((AbstractList)this.children).iterator();
        while (iter.hasNext()) {
            methodStrings.add(((MethodNode)iter.next()).getBreakpoint());
        }
        return methodStrings;
    }
}

