/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import javax.swing.JScrollPane;
import org.aspectj.debugger.base.DebuggerListener;
import org.aspectj.debugger.gui.AJPanel;
import org.aspectj.debugger.gui.BreakpointTree;
import org.aspectj.debugger.gui.BreakpointTreeModel;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.RequestEvent;

public class BreakpointTreePane
extends AJPanel
implements DebuggerListener {
    private BreakpointTree tree = null;
    private JScrollPane scrollPane = null;

    public BreakpointTreePane(Frame frame, GUIDebugger guid) {
        super(guid);
        this.debugger().addDebuggerListener(this);
        this.setLayout(new BorderLayout());
        this.tree = new BreakpointTree(frame);
        this.scrollPane = new JScrollPane(this.tree);
        this.add((Component)this.scrollPane, "Center");
    }

    public BreakpointTreePane() {
        this(null, null);
    }

    BreakpointTreeModel getModel() {
        return (BreakpointTreeModel)this.tree.getModel();
    }

    void modernizeTree() {
        this.tree.modernize();
    }

    void add(Object o, boolean verified, Location loc) {
        ((BreakpointTreeModel)this.tree.getModel()).add(o, verified, loc);
        this.tree.modernize();
    }

    void remove(Object o) {
        ((BreakpointTreeModel)this.tree.getModel()).remove(o);
        this.tree.modernize();
    }

    public void requestSetEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof BreakpointRequestAction)) {
            return;
        }
        BreakpointRequestAction ra = (BreakpointRequestAction)r;
        this.add(ra, true, ra.getLocation());
    }

    public void requestClearEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof BreakpointRequestAction)) {
            return;
        }
        BreakpointRequestAction ra = (BreakpointRequestAction)r;
        this.remove(ra);
    }

    public void requestDeferredEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof BreakpointRequestAction)) {
            return;
        }
        BreakpointRequestAction ra = (BreakpointRequestAction)r;
        this.add(ra, false, ra.getLocation());
    }

    public void requestFailedEvent(RequestEvent re) {
        Request r = re.getRequest();
        if (!(r instanceof BreakpointRequestAction)) {
            return;
        }
        BreakpointRequestAction ra = (BreakpointRequestAction)r;
        this.remove(ra);
    }

    public static String d() {
        return "Breakpoint Tree Pane";
    }

    public String toString() {
        return BreakpointTreePane.d();
    }
}

