/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.ClassTextField;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.SourceTextField;
import org.aspectj.util.gui.CenteredJDialog;

public class BreakpointDialog
extends CenteredJDialog {
    static final int CLASS1_COLS = 20;
    static final int LINE_COLS = 5;
    final String job = this.isSetting() ? "Set" : "Clear";
    String classMethodMsg = this.job + " a method breakpoint";
    ClassTextField classText1 = new ClassTextField(20);
    JTextField lineText = new JTextField(5);
    static final int CLASS2_COLS = 20;
    static final int METHOD_COLS = 20;
    static final int PARAMS_COLS = 42;
    String classLineMsg = this.job + " a class-line breakpoint";
    JTextField classText2 = new JTextField(20);
    JTextField methodText = new JTextField(20);
    JTextField paramsText = new JTextField(42);
    static final int SOURCE_COLS = 20;
    String sourceLineMsg = this.job + " a source-line breakpoint";
    SourceTextField sourceText = new SourceTextField(20);
    JTextField lineText2 = new JTextField(5);

    public boolean isSetting() {
        return true;
    }

    public BreakpointDialog(Frame frame) {
        super(frame, "", true);
        this.setTitle(this.job + " a Breakpoint");
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BoxLayout(mainPanel, 1));
        mainPanel.add(this.classMethodPanel());
        mainPanel.add(this.classLinePanel());
        mainPanel.add(this.sourceLinePanel());
        mainPanel.add(this.buttonPanel());
        this.setResizable(false);
        this.setContentPane(mainPanel);
        this.setDefaultCloseOperation(2);
    }

    JPanel classLinePanel() {
        KeyAdapter potato = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BreakpointDialog.this.setClassLineBreakpoint();
                }
            }
        };
        this.classText1.addKeyListener(potato);
        this.lineText.addKeyListener(potato);
        JPanel classTextPanel1 = new JPanel();
        classTextPanel1.setLayout(new BoxLayout(classTextPanel1, 1));
        classTextPanel1.add(Box.createHorizontalGlue());
        classTextPanel1.add(this.classText1);
        classTextPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Class"));
        JPanel lineTextPanel = new JPanel();
        lineTextPanel.setLayout(new BoxLayout(lineTextPanel, 1));
        lineTextPanel.add(Box.createHorizontalGlue());
        lineTextPanel.add(this.lineText);
        lineTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Line"));
        JPanel mainPanel1 = new JPanel();
        mainPanel1.setLayout(new BoxLayout(mainPanel1, 0));
        mainPanel1.add(classTextPanel1);
        mainPanel1.add(lineTextPanel);
        JButton jobButton = null;
        if (this.isSetting()) {
            jobButton = new JButton("Set");
            jobButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BreakpointDialog.this.setClassLineBreakpoint();
                }
            });
        } else {
            jobButton = new JButton("Clear");
            jobButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BreakpointDialog.this.classLineClear();
                }
            });
        }
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new BoxLayout(buttonPanel1, 0));
        buttonPanel1.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPanel1.add(Box.createHorizontalGlue());
        buttonPanel1.add(jobButton);
        JPanel classLinePanel = new JPanel();
        classLinePanel.setLayout(new BorderLayout());
        classLinePanel.add((Component)mainPanel1, "Center");
        classLinePanel.add((Component)buttonPanel1, "South");
        classLinePanel.setBorder(BorderFactory.createTitledBorder(this.classLineMsg));
        return classLinePanel;
    }

    JPanel classMethodPanel() {
        KeyAdapter george = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BreakpointDialog.this.setClassMethodBreakpoint();
                }
            }
        };
        this.classText2.addKeyListener(george);
        this.methodText.addKeyListener(george);
        this.paramsText.addKeyListener(george);
        JPanel classTextPanel2 = new JPanel();
        classTextPanel2.setLayout(new BoxLayout(classTextPanel2, 1));
        classTextPanel2.add(Box.createHorizontalGlue());
        classTextPanel2.add(this.classText2);
        classTextPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Class"));
        JPanel methodTextPanel = new JPanel();
        methodTextPanel.setLayout(new BoxLayout(methodTextPanel, 1));
        methodTextPanel.add(Box.createHorizontalGlue());
        methodTextPanel.add(this.methodText);
        methodTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Method"));
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 0));
        topPanel.add(classTextPanel2);
        topPanel.add(methodTextPanel);
        JPanel paramsTextPanel = new JPanel();
        paramsTextPanel.setLayout(new BoxLayout(paramsTextPanel, 1));
        paramsTextPanel.add(Box.createHorizontalGlue());
        paramsTextPanel.add(this.paramsText);
        paramsTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Parameters"));
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BoxLayout(bottomPanel, 0));
        bottomPanel.add(paramsTextPanel);
        JPanel middlePanel = new JPanel();
        middlePanel.setLayout(new BoxLayout(middlePanel, 1));
        middlePanel.add(topPanel);
        middlePanel.add(bottomPanel);
        JButton jobButton = null;
        if (this.isSetting()) {
            jobButton = new JButton("Set");
            jobButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BreakpointDialog.this.setClassMethodBreakpoint();
                }
            });
        } else {
            jobButton = new JButton("Clear");
            jobButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BreakpointDialog.this.classMethodClear();
                }
            });
        }
        JPanel buttonPanel2 = new JPanel();
        buttonPanel2.setLayout(new BoxLayout(buttonPanel2, 0));
        buttonPanel2.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPanel2.add(Box.createHorizontalGlue());
        buttonPanel2.add(jobButton);
        JPanel classMethodPanel = new JPanel();
        classMethodPanel.setLayout(new BorderLayout());
        classMethodPanel.add((Component)middlePanel, "Center");
        classMethodPanel.add((Component)buttonPanel2, "South");
        classMethodPanel.setBorder(BorderFactory.createTitledBorder(this.classMethodMsg));
        return classMethodPanel;
    }

    JPanel sourceLinePanel() {
        KeyAdapter potato = new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    BreakpointDialog.this.setSourceLineBreakpoint();
                }
            }
        };
        this.sourceText.addKeyListener(potato);
        this.lineText2.addKeyListener(potato);
        JPanel classTextPanel1 = new JPanel();
        classTextPanel1.setLayout(new BoxLayout(classTextPanel1, 1));
        classTextPanel1.add(Box.createHorizontalGlue());
        classTextPanel1.add(this.sourceText);
        classTextPanel1.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Source"));
        JPanel lineTextPanel = new JPanel();
        lineTextPanel.setLayout(new BoxLayout(lineTextPanel, 1));
        lineTextPanel.add(Box.createHorizontalGlue());
        lineTextPanel.add(this.lineText2);
        lineTextPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0), "Line"));
        JPanel mainPanel1 = new JPanel();
        mainPanel1.setLayout(new BoxLayout(mainPanel1, 0));
        mainPanel1.add(classTextPanel1);
        mainPanel1.add(lineTextPanel);
        JButton jobButton = null;
        if (this.isSetting()) {
            jobButton = new JButton("Set");
            jobButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BreakpointDialog.this.setSourceLineBreakpoint();
                }
            });
        } else {
            jobButton = new JButton("Clear");
            jobButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    BreakpointDialog.this.sourceLineClear();
                }
            });
        }
        JPanel buttonPanel1 = new JPanel();
        buttonPanel1.setLayout(new BoxLayout(buttonPanel1, 0));
        buttonPanel1.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        buttonPanel1.add(Box.createHorizontalGlue());
        buttonPanel1.add(jobButton);
        JPanel sourceLinePanel = new JPanel();
        sourceLinePanel.setLayout(new BorderLayout());
        sourceLinePanel.add((Component)mainPanel1, "Center");
        sourceLinePanel.add((Component)buttonPanel1, "South");
        sourceLinePanel.setBorder(BorderFactory.createTitledBorder(this.sourceLineMsg));
        return sourceLinePanel;
    }

    JPanel buttonPanel() {
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                BreakpointDialog.this.cancel();
            }
        });
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new BoxLayout(buttonPanel, 0));
        buttonPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(cancelButton);
        return buttonPanel;
    }

    public BreakpointDialog() {
        this((Frame)null);
    }

    public void show() {
        this.pack();
        super.show();
    }

    String getClass1() {
        return this.classText1.getText();
    }

    String getClass2() {
        return this.classText2.getText();
    }

    private void setClassLineBreakpoint() {
        String className = this.classText1.getText();
        int line = -1;
        try {
            line = Integer.parseInt(this.lineText.getText());
        }
        catch (NumberFormatException e) {
            AJUtil.warn("The line field must contain a number");
            return;
        }
        String cmd = "stop at " + className + ":" + line;
        ComponentRepository.getCommandLine().executeCommand(cmd);
        this.hide();
    }

    private void classLineClear() {
        this.classText1.setText("");
        this.lineText.setText("");
    }

    private void setSourceLineBreakpoint() {
        String sourceName = this.sourceText.getText();
        int line = -1;
        try {
            line = Integer.parseInt(this.lineText2.getText());
        }
        catch (NumberFormatException e) {
            AJUtil.warn("The line field must contain a number");
            return;
        }
        String cmd = "stop on " + sourceName + ":" + line;
        ComponentRepository.getCommandLine().executeCommand(cmd);
        this.hide();
    }

    private void sourceLineClear() {
        this.sourceText.setText("");
        this.lineText2.setText("");
    }

    private void setClassMethodBreakpoint() {
        String cmd = "stop in ";
        String className = this.classText2.getText();
        String method = this.methodText.getText();
        String params = "";
        StringTokenizer tok = new StringTokenizer(this.paramsText.getText(), " ;,");
        params = params + "(";
        while (tok.hasMoreTokens()) {
            params = params + tok.nextToken();
            params = params + (tok.hasMoreTokens() ? "," : "");
        }
        params = params + ")";
        cmd = cmd + className + "." + method + params;
        ComponentRepository.getCommandLine().executeCommand(cmd);
        this.hide();
    }

    private void classMethodClear() {
        this.classText2.setText("");
        this.methodText.setText("");
        this.paramsText.setText("");
    }

    private void cancel() {
        this.hide();
    }

    public static void main(String[] args) {
        BreakpointDialog d = new BreakpointDialog();
        d.show();
    }
}

