/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.aspectj.debugger.gui.GUIDebugger;

public abstract class AbstractTextArea
extends JPanel {
    protected static final int TEXT_ROWS = 30;
    protected static final int TEXT_COLS = 50;
    protected static final int TEXT_SIZE = 12;
    protected static final Dimension TEXT_DIM = new Dimension(30, 50);
    protected static final int OUT = 0;
    protected static final int NOTICE = 1;
    protected static final int ERR = 2;
    protected static final String NEWLINE = System.getProperty("line.separator");
    protected PrintStream printStream = null;
    protected JScrollPane scrollPane = null;
    protected DefaultStyledDocument dsd = new DefaultStyledDocument();
    protected JTextArea text;
    protected SimpleAttributeSet[] attrs = null;
    protected Color[] colors = new Color[]{Color.black, Color.blue.darker(), Color.red.darker()};
    protected int textSize = 12;
    protected GUIDebugger guiDebugger;
    private int count = 0;

    public final void superInit(GUIDebugger guiDebugger) {
        this.guiDebugger = guiDebugger;
        this.setLayout(new BoxLayout(this, 1));
        this.text = new JTextArea(0, 0);
        this.text.setEditable(false);
        this.printStream = this.createPrintStream();
        this.scrollPane = new JScrollPane(this.text);
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.add(this.scrollPane);
        this.initAttrs();
    }

    protected abstract PrintStream createPrintStream();

    public PrintStream getPrintStream() {
        return this.printStream;
    }

    public void setTextSize(int textSize) {
        this.textSize = textSize;
    }

    public abstract void restorePrintStream();

    public void shutDown() {
        this.restorePrintStream();
    }

    protected void out(String s) {
        this.append(s, 0);
    }

    protected void outln(String s) {
        this.append(s, 0);
        this.newline();
    }

    protected void err(String s) {
        this.append(s, 2);
    }

    protected void errln(String s) {
        this.append(s, 2);
        this.newline();
    }

    protected void notice(String s) {
        this.append(s, 1);
    }

    protected void noticeln(String s) {
        this.append(s, 1);
        this.newline();
    }

    protected void append(String s, int i) {
        this.text.append(s);
    }

    protected void newline() {
        this.append(NEWLINE, -1);
    }

    protected void initAttrs() {
        this.attrs = new SimpleAttributeSet[this.colors.length];
        int i = 0;
        while (i < this.colors.length) {
            this.attrs[i] = this.getAttr(this.colors[i]);
            ++i;
        }
    }

    protected SimpleAttributeSet getAttr(Color c) {
        SimpleAttributeSet attr = new SimpleAttributeSet();
        StyleConstants.setForeground(attr, c);
        StyleConstants.setFontSize(attr, this.textSize);
        return attr;
    }

    protected static class TextPrintErrStream
    extends PrintStream {
        public TextPrintErrStream(AbstractTextArea text) {
            super(new OutputStream(text){
                private final /* synthetic */ AbstractTextArea val$text;
                {
                    this.val$text = val$text;
                }

                public void write(int b) throws IOException {
                    this.val$text.err(String.valueOf((char)b));
                }
            });
        }
    }

    protected static class TextPrintNoticeStream
    extends PrintStream {
        public TextPrintNoticeStream(AbstractTextArea text) {
            super(new OutputStream(text){
                private final /* synthetic */ AbstractTextArea val$text;
                {
                    this.val$text = val$text;
                }

                public void write(int b) throws IOException {
                    this.val$text.notice(String.valueOf((char)b));
                }
            });
        }
    }

    protected static class TextPrintOutStream
    extends PrintStream {
        public TextPrintOutStream(AbstractTextArea text) {
            super(new OutputStream(text){
                private final /* synthetic */ AbstractTextArea val$text;
                {
                    this.val$text = val$text;
                }

                public void write(int b) throws IOException {
                    this.val$text.out(String.valueOf((char)b));
                }
            });
        }
    }
}

