/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.StackFrame;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import java.io.File;
import org.aspectj.debugger.base.DebuggerListener;
import org.aspectj.debugger.base.SourceManager;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.AJPanel;
import org.aspectj.debugger.gui.ComponentDirector;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.request.BreakpointRequestAction;
import org.aspectj.debugger.request.Request;
import org.aspectj.debugger.request.RequestEvent;
import org.aspectj.tools.ide.SourceLine;

public abstract class AbstractSourcePane
extends AJPanel
implements DebuggerListener,
VMListener,
StopListener {
    protected ComponentDirector director;

    public AbstractSourcePane(GUIDebugger guid) {
        super(guid);
        this.debugger().addDebuggerListener(this);
        this.debugger().addVMListener(this);
        this.debugger().addStopListener(this);
        this.director = guid.getGui();
    }

    public abstract boolean showSource(String var1);

    public abstract void showLineForCurrentModel(int var1, boolean var2);

    public abstract String getSourceName();

    public abstract void requestSet(String var1, int var2, BreakpointRequestAction var3);

    public abstract void requestClear(String var1, int var2, BreakpointRequestAction var3);

    public abstract void requestDeferred(String var1, int var2, BreakpointRequestAction var3);

    public boolean fileExists(String relativePath) {
        String fullPath = this.debugger().getFullSourcePath(relativePath);
        File file = new File(fullPath);
        return file != null && file.exists();
    }

    public String getSourcePath() {
        return this.debugger().getSourceManager().getSourcePath();
    }

    public SourceManager getSourceManager() {
        return this.debugger.getSourceManager();
    }

    public void showSourceForFrame(StackFrame frame, boolean isAtBreakpoint) {
        try {
            this.showSourceForLocation(frame.location(), isAtBreakpoint);
        }
        catch (InvalidStackFrameException invalidStackFrameException) {
            // empty catch block
        }
    }

    public void showSourceForLocation(Location loc, boolean isAtBreakpoint) {
        SourceLine sl = null;
        try {
            sl = this.debugger().sourceLine(loc);
        }
        catch (AbsentInformationException aie) {
            return;
        }
        if (sl == null) {
            return;
        }
        if (sl.line < 0) {
            return;
        }
        if (this.fileExists(sl.filename) && this.showSource(sl.filename)) {
            this.showLineForCurrentModel(sl.line, isAtBreakpoint);
        }
        this.director.makeTopLevel();
    }

    public void showSourceForLocation(Location loc) {
        this.showSourceForLocation(loc, false);
    }

    public void showSourceForFileAndLine(String relativePath, int line) {
        if (line < 0) {
            return;
        }
        if (!new File(relativePath).exists() && !new File(AJLineMapper.removeRoot(relativePath)).exists()) {
            return;
        }
        if (this.fileExists(relativePath) && this.showSource(relativePath)) {
            this.showLineForCurrentModel(line);
        }
        this.director.makeTopLevel();
    }

    protected void showLineForCurrentModel(int line) {
        this.showLineForCurrentModel(line, false);
    }

    public File getPath() {
        return new File(this.getSourceName());
    }

    public void requestSetEvent(RequestEvent re) {
        Request request = re.getRequest();
        if (request instanceof BreakpointRequestAction) {
            BreakpointRequestAction ba = (BreakpointRequestAction)request;
            SourceLine sl = this.debugger().getSourceLine(ba);
            this.requestSet(sl.filename, sl.line, ba);
        }
    }

    public void requestClearEvent(RequestEvent re) {
        Request request = re.getRequest();
        if (request instanceof BreakpointRequestAction) {
            BreakpointRequestAction ba = (BreakpointRequestAction)request;
            SourceLine sl = this.debugger().getSourceLine(ba);
            this.requestClear(sl.filename, sl.line, ba);
        }
    }

    public void requestDeferredEvent(RequestEvent re) {
        Request request = re.getRequest();
        if (request instanceof BreakpointRequestAction) {
            BreakpointRequestAction ba = (BreakpointRequestAction)request;
            SourceLine sl = this.debugger().getSourceLine(ba);
            this.requestDeferred(sl.filename, sl.line, ba);
        }
    }

    public void requestFailedEvent(RequestEvent re) {
    }

    public void vmStartEvent(VMStartEvent e) {
    }

    public void vmDeathEvent(VMDeathEvent e) {
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
    }

    public void accessWatchpointEvent(AccessWatchpointEvent e) {
        this.showSourceForLocation(e.location());
    }

    public void breakpointEvent(BreakpointEvent e) {
        this.showSourceForLocation(e.location());
    }

    public void exceptionEvent(ExceptionEvent e) {
        this.showSourceForLocation(e.location());
    }

    public void modificationWatchpointEvent(ModificationWatchpointEvent e) {
        this.showSourceForLocation(e.location());
    }

    public void stepEvent(StepEvent e) {
        this.showSourceForLocation(e.location());
    }

    public static String d() {
        return "Source Pane";
    }

    public String toString() {
        return AbstractSourcePane.d();
    }
}

