/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.awt.event.MouseEvent;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJStackFrameNode;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AJTreeNodeMenu;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.Dialogs;
import org.aspectj.debugger.gui.FieldGetter;
import org.aspectj.debugger.gui.Util;

public class AJValueNode
extends AJTreeNode {
    protected AJValueGetter getter = null;

    public AJValueNode(AJValueGetter getter, int type) {
        super(type);
        this.getter = getter;
    }

    public AJValueNode(AJValueGetter getter) {
        this(getter, AJIcons.BAD_ICON);
        this.setType(this._getType());
    }

    public Value getValue() {
        return this.getter.getValue();
    }

    public Value getValue(String s) {
        return this.getter.getValue(s);
    }

    public ReferenceType getDeclaringClass() {
        return this.getter.getDeclaringClass();
    }

    public boolean canSetWatchPoint() {
        return this.getDeclaringClass() != null;
    }

    public void setValue(Object o) throws DebuggerException {
        if (o == null) {
            return;
        }
        AJTreeNode parent = (AJTreeNode)this.getParent();
        while (!parent.isStackFrame()) {
            parent = (AJTreeNode)parent.getParent();
        }
        AJStackFrameNode parentHack = (AJStackFrameNode)parent;
        try {
            this.getter.setValue(ComponentRepository.getAJDebugger().getValue(o, parentHack.getStackFrame()));
        }
        catch (ClassNotLoadedException cnle) {
        }
        catch (InvalidTypeException ite) {
            AJUtil.ex(ite);
        }
    }

    public void setWatchPoint() {
        ReferenceType refType = this.getDeclaringClass();
        if (refType == null) {
            AJUtil.warn("You cannot set a watchpoint on: " + this);
            return;
        }
        String declaringType = refType.name();
        String name = this.getName();
        String command = "watch " + declaringType + "." + name;
        ComponentRepository.getCommandLine().executeCommand(command);
    }

    public ThreadReference getThread() throws ClassNotLoadedException, IncompatibleThreadStateException {
        return this.getter.getThread();
    }

    public String getName() {
        return this.getter.getName();
    }

    public Type getTypeRef() throws ClassNotLoadedException {
        return this.getter.getTypeRef();
    }

    public String getTypeName() {
        try {
            return this.getter.getTypeName();
        }
        catch (Exception e) {
            Util.error(e);
            return "";
        }
    }

    public String getValueString() {
        try {
            return "" + this.getter.getValue();
        }
        catch (Exception exception) {
            return "";
        }
    }

    public String toString() {
        String name = "<no-name>";
        String type = "<no-type>";
        Value value = null;
        try {
            name = this.getter.getName();
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            type = AJUtil.stripParens(this.getter.getTypeName());
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            value = this.getValue();
        }
        catch (InvalidStackFrameException isfe) {
            // empty catch block
        }
        return name + ": " + type + " = " + this.format(value);
    }

    protected String format(Value value) {
        return value + "";
    }

    public boolean isField() {
        return this.g() instanceof FieldGetter;
    }

    private int _getType() {
        if (this.isField()) {
            FieldGetter g = (FieldGetter)((Object)this.g());
            Field field = g.getField();
            if (field.isStatic()) {
                if (field.isPublic()) {
                    return AJIcons.FIELD_STATIC_PUBLIC_ICON;
                }
                if (field.isPackagePrivate()) {
                    return AJIcons.FIELD_STATIC_PACKAGE_ICON;
                }
                if (field.isProtected()) {
                    return AJIcons.FIELD_STATIC_PROTECTED_ICON;
                }
                if (field.isPrivate()) {
                    return AJIcons.FIELD_STATIC_PRIVATE_ICON;
                }
            } else {
                if (field.isPublic()) {
                    return AJIcons.FIELD_PUBLIC_ICON;
                }
                if (field.isPackagePrivate()) {
                    return AJIcons.FIELD_PACKAGE_ICON;
                }
                if (field.isProtected()) {
                    return AJIcons.FIELD_PROTECTED_ICON;
                }
                if (field.isPrivate()) {
                    return AJIcons.FIELD_PRIVATE_ICON;
                }
            }
        }
        return this.getType();
    }

    protected AJValueGetter g() {
        return this.getter;
    }

    public void leftMouseButton(MouseEvent e) {
    }

    public void middleMouseButton(MouseEvent e) {
        AJTreeNodeMenu.showValueNodeMenu(this, e.getComponent(), e.getX(), e.getY());
    }

    public void rightMouseButton(MouseEvent e) {
        AJTreeNodeMenu.showValueNodeMenu(this, e.getComponent(), e.getX(), e.getY());
    }

    public void setValue() {
        Dialogs.showNewValueDialog(this);
    }

    public boolean isValueNode() {
        return true;
    }
}

