/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.VMDisconnectedException;
import java.awt.Dimension;
import java.util.Enumeration;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.aspectj.debugger.gui.AJRootNode;
import org.aspectj.debugger.gui.AJTreeExpansionListener;
import org.aspectj.debugger.gui.AJTreeNode;
import org.aspectj.debugger.gui.AJTreeWillExpandListener;

public abstract class AJTree
extends JTree {
    public AJTree(TreeModel model) {
        super(model);
        this.init();
    }

    public AJTree() {
        this.init();
    }

    public AJTree(AJRootNode root) {
        super(root);
        this.init();
    }

    public AJRootNode getRoot() {
        return (AJRootNode)this.getModel().getRoot();
    }

    public void setRoot(AJRootNode root) {
        ((DefaultTreeModel)this.getModel()).setRoot(root);
    }

    protected void expand() {
        int row = 0;
        while (row < this.getRowCount()) {
            this.expandRow(row++);
        }
    }

    public abstract void clear();

    public void reloadAll() {
        DefaultTreeModel model = (DefaultTreeModel)this.getModel();
        Enumeration<TreeNode> nodes = ((DefaultMutableTreeNode)model.getRoot()).breadthFirstEnumeration();
        while (nodes.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)nodes.nextElement();
            if (!node.isLeaf() && !((AJTreeNode)node).isString()) continue;
            model.reload(node);
        }
    }

    public final void modernize() {
        Runnable update = new Runnable(){

            public void run() {
                try {
                    AJTree.this.doModernize();
                }
                catch (VMDisconnectedException vMDisconnectedException) {
                    // empty catch block
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            update.run();
        } else {
            SwingUtilities.invokeLater(update);
        }
    }

    public void doModernize() {
        AJTree.super.updateUI();
    }

    protected final void init() {
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setEditable(false);
        this.setMinimumSize(new Dimension(100, 200));
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeWillExpandListener(new AJTreeWillExpandListener(this));
        this.addTreeExpansionListener(new AJTreeExpansionListener(this));
    }
}

