/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import com.sun.jdi.event.AccessWatchpointEvent;
import com.sun.jdi.event.BreakpointEvent;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.ModificationWatchpointEvent;
import com.sun.jdi.event.StepEvent;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.event.VMDeathEvent;
import com.sun.jdi.event.VMDisconnectEvent;
import com.sun.jdi.event.VMStartEvent;
import java.awt.Component;
import java.util.Iterator;
import javax.swing.JScrollPane;
import org.aspectj.debugger.base.StopListener;
import org.aspectj.debugger.base.ThreadListener;
import org.aspectj.debugger.base.VMListener;
import org.aspectj.debugger.gui.AJThreadGroupTree;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.debugger.gui.GUIDebugger;

public class AJThreadGroupTreePane
extends JScrollPane
implements StopListener,
VMListener,
ThreadListener {
    public AJThreadGroupTree tree = null;
    private GUIDebugger guid;

    public AJThreadGroupTreePane(AJThreadGroupTree tree) {
        this.tree = tree;
        this.addTree();
    }

    public AJThreadGroupTreePane(GUIDebugger guid) {
        this(new AJThreadGroupTree());
        this.guid = guid;
        guid.getDebugger().addStopListener(this);
        guid.getDebugger().addVMListener(this);
        guid.getDebugger().addThreadListener(this);
    }

    public boolean add(ThreadReference ref) {
        return this.tree.add(ref);
    }

    public boolean remove(ThreadReference ref) {
        return this.tree.remove(ref);
    }

    public void clear() {
        this.tree.clear();
    }

    public void modernizeTree() {
        try {
            this.tree.modernize();
        }
        catch (Exception e) {
            AJUtil.ex(e);
        }
    }

    public void invalidateAllThreads() {
        this.tree.invalidateAllThreads();
    }

    public void expandToFrame(StackFrame frame) {
        this.guid.getGui().showThreadPane();
        this.tree.expandToFrame(frame);
        this.centerTreeSelection();
    }

    public void expandToLocals(StackFrame frame) {
        this.guid.getGui().showThreadPane();
        this.tree.expandToLocals(frame);
        this.centerTreeSelection();
    }

    protected void centerTreeSelection() {
    }

    public void expandToValue(Value value, String name) {
        this.tree.expandToValue(value, name);
        this.centerTreeSelection();
    }

    public AJThreadGroupTree getTree() {
        return this.tree;
    }

    private void addTree() {
        this.getViewport().add((Component)this.tree, "Center");
    }

    public void vmDeathEvent(VMDeathEvent e) {
        this.tree.clear();
    }

    public void vmDisconnectEvent(VMDisconnectEvent e) {
        this.tree.clear();
    }

    public void vmStartEvent(VMStartEvent e) {
        try {
            Iterator<ThreadReference> iter = ComponentRepository.vm().allThreads().iterator();
            while (iter.hasNext()) {
                this.tree.add(iter.next());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.modernizeTree();
    }

    public void accessWatchpointEvent(AccessWatchpointEvent e) {
        this.modernizeTree();
    }

    public void breakpointEvent(BreakpointEvent e) {
        this.modernizeTree();
    }

    public void exceptionEvent(ExceptionEvent e) {
        this.modernizeTree();
    }

    public void modificationWatchpointEvent(ModificationWatchpointEvent e) {
        this.modernizeTree();
    }

    public void stepEvent(StepEvent e) {
        this.modernizeTree();
    }

    public void threadDeathEvent(ThreadDeathEvent e) {
        this.tree.remove(e.thread());
    }

    public void threadStartEvent(ThreadStartEvent e) {
        this.tree.add(e.thread());
    }

    public static String d() {
        return "Thread Group Tree Pane";
    }

    public String toString() {
        return AJThreadGroupTreePane.d();
    }
}

