/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StringReference;
import java.util.Iterator;
import org.aspectj.debugger.gui.AJClassNode;
import org.aspectj.debugger.gui.AJIcons;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.AJValueGetter;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.AJValueNodeFactory;
import org.aspectj.debugger.gui.Util;

public class AJObjectValueNode
extends AJValueNode {
    public AJObjectValueNode(AJValueGetter getter) {
        super(getter);
        this.setType(AJIcons.OBJECT_ICON);
    }

    public boolean isObject() {
        return true;
    }

    public boolean isString() {
        return this.getValue() instanceof StringReference;
    }

    public void showKids() {
        if (this.getChildCount() == 0) {
            this.showValues();
        }
    }

    public int getType() {
        return this.g().getValue() == null ? AJIcons.NULL_OBJECT_ICON : super.getType();
    }

    private void showValues() {
        this.hideValues();
        try {
            ObjectReference parent = (ObjectReference)this.g().getValue();
            ReferenceType refType = parent.referenceType();
            this.add(new AJClassNode(refType));
            Iterator<Field> iter = refType.allFields().iterator();
            while (iter.hasNext()) {
                Field field = iter.next();
                if (field.isStatic()) continue;
                AJValueNode valueNode = AJValueNodeFactory.make(parent, field);
                this.add(valueNode);
            }
        }
        catch (Exception e) {
            Util.ex(e);
        }
    }

    public void hideValues() {
        this.removeAllChildren();
    }

    public String getValueString() {
        String str = "no class loader";
        try {
            String type = AJUtil.stripParens(this.g().getTypeName());
            str = type.startsWith("java.lang.String") ? "" + this.g().getValue() : type + " instance";
        }
        catch (ClassNotLoadedException classNotLoadedException) {
            // empty catch block
        }
        return str;
    }
}

