/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.gui.AJObjectValueNode;
import org.aspectj.debugger.gui.AJUtil;
import org.aspectj.debugger.gui.AJValueNode;
import org.aspectj.debugger.gui.ComponentRepository;
import org.aspectj.util.gui.CenteredJDialog;

public class AJNewValueDialog
extends CenteredJDialog {
    private AJValueNode valueNode = null;
    private JOptionPane optionPane = null;
    private JTextField textField = null;
    private JButton button1 = null;
    private JButton button2 = null;
    private JLabel messageLabel = null;
    private static final int TEXTFIELD_WIDTH = 20;
    private static final String TAB = "        ";

    public AJNewValueDialog(Frame frame, AJValueNode valueNode) {
        super(frame, "Change a Value", true);
        this.valueNode = valueNode;
        String message1 = "Change a value";
        this.textField = new JTextField(20);
        this.textField.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    AJNewValueDialog.this.setValue();
                }
            }
        });
        this.clearText();
        this.messageLabel = new JLabel();
        this.clearMessage();
        Object[] components = new Object[]{message1, this.textField, this.messageLabel};
        this.button1 = new JButton("Change");
        this.button1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AJNewValueDialog.this.setValue();
            }
        });
        this.button2 = new JButton("Clear");
        this.button2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AJNewValueDialog.this.clearText();
            }
        });
        Object[] buttons = new Object[]{this.button1, this.button2};
        this.optionPane = new JOptionPane(components, 3, 0, null, buttons, buttons[0]);
        this.setContentPane(this.optionPane);
        this.setDefaultCloseOperation(2);
    }

    public String getValueText() {
        String text = this.textField.getText();
        if (this.valueNode instanceof AJObjectValueNode && ((AJObjectValueNode)this.valueNode).isString()) {
            text = '\"' + text + '\"';
        }
        return text;
    }

    private void setValue() {
        if (this.valueNode == null) {
            return;
        }
        try {
            this.valueNode.setValue(this.getValueText());
            ComponentRepository.getThreadGroupTreePane().getTree().reloadAll();
            this.clearText();
            ((Component)this).setVisible(false);
        }
        catch (NumberFormatException e4) {
            this.err(e4);
        }
        catch (IllegalArgumentException e6) {
            this.err(e6);
        }
        catch (DebuggerException de) {
            ComponentRepository.getGUIDebugger().handleDebuggerException(de);
        }
    }

    private void err(Throwable e) {
        String message = e.getMessage();
        if (e instanceof NumberFormatException) {
            message = message + " is too BIG!";
        }
        this.message(message);
        this.clearText();
        AJUtil.ex(e);
    }

    public void popup(AJValueNode valueNode) {
        this.valueNode = valueNode;
        this.setTitle("change: " + valueNode);
        this.clearText();
        this.clearMessage();
        this.pack();
        ((Component)this).setVisible(true);
    }

    public void popup() {
        this.setTitle("change: " + this.valueNode);
        this.clearText();
        this.clearMessage();
        this.pack();
        ((Component)this).setVisible(true);
    }

    private void message(String s) {
        this.messageLabel.setText(s);
    }

    private void clearMessage() {
        this.messageLabel.setText("");
    }

    private void clearText() {
        this.textField.setText("");
        this.textField.requestFocus();
    }
}

