/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;
import org.aspectj.debugger.base.AJDebugger;
import org.aspectj.debugger.gui.AJActionsConsts;
import org.aspectj.debugger.gui.AboutAction;
import org.aspectj.debugger.gui.AbstractActionStruct;
import org.aspectj.debugger.gui.BreakpointAction;
import org.aspectj.debugger.gui.CatchAction;
import org.aspectj.debugger.gui.ClearAction;
import org.aspectj.debugger.gui.ContAction;
import org.aspectj.debugger.gui.Dialogs;
import org.aspectj.debugger.gui.DisconnectAction;
import org.aspectj.debugger.gui.DumpAction;
import org.aspectj.debugger.gui.EvalAction;
import org.aspectj.debugger.gui.FieldsAction;
import org.aspectj.debugger.gui.GUIDebugger;
import org.aspectj.debugger.gui.HelpAction;
import org.aspectj.debugger.gui.LocalsAction;
import org.aspectj.debugger.gui.NextAction;
import org.aspectj.debugger.gui.PrintAction;
import org.aspectj.debugger.gui.QuitAction;
import org.aspectj.debugger.gui.ResumeAction;
import org.aspectj.debugger.gui.RunAction;
import org.aspectj.debugger.gui.StepAction;
import org.aspectj.debugger.gui.StepIAction;
import org.aspectj.debugger.gui.StepUpAction;
import org.aspectj.debugger.gui.SuspendAction;
import org.aspectj.debugger.gui.ThreadGetter;
import org.aspectj.debugger.gui.UseAction;
import org.aspectj.debugger.gui.WhereAction;
import org.aspectj.debugger.request.MonitorRequest;

public class AJMenuBar
extends JMenuBar
implements AJActionsConsts {
    private JMenu menu;
    private JMenuItem item;
    private GUIDebugger guiDebugger;
    static final String jdk = "1.2";

    public AJMenuBar(GUIDebugger guiDebugger) {
        this.guiDebugger = guiDebugger;
        this.mainMenu();
        this.breakMenu();
        this.threadMenu();
        this.objectMenu();
        this.monitorMenu();
        this.aspects();
        this.helpMenu();
    }

    void aspects() {
    }

    void mainMenu() {
        this.menu("Main", 77);
        this.item(new RunAction(this.guiDebugger), 82);
        this.item(new UseAction(this.guiDebugger), 85);
        this.item(new DisconnectAction(this.guiDebugger), 68);
        this.sep();
        this.item(new QuitAction(this.guiDebugger), 81);
        this.add(this.menu);
    }

    void breakMenu() {
        this.menu("Breakpoints", 66);
        this.item(new BreakpointAction(this.guiDebugger), 66);
        this.item(new CatchAction(this.guiDebugger), 65);
        this.item(new ClearAction(this.guiDebugger), 67);
        this.sep();
        this.item(new ContAction(this.guiDebugger), 79);
        this.item(new NextAction(this.guiDebugger), 78);
        this.item(new StepAction(this.guiDebugger), 83);
        this.item(new StepUpAction(this.guiDebugger), 85);
        this.item(new StepIAction(this.guiDebugger), 73);
        this.add(this.menu);
    }

    void threadMenu() {
        this.menu("Threads", 84);
        this.item(new SuspendAction(this.guiDebugger, this.threadGetterToSuspend()), 83);
        this.item(new ResumeAction(this.guiDebugger, this.threadGetterToResume()), 82);
        this.item(new WhereAction(this.guiDebugger, this.threadGetterToWhere()), 87);
        this.add(this.menu);
    }

    void objectMenu() {
        this.menu("Objects", 84);
        this.item(new DumpAction(this.guiDebugger), 68);
        this.item(new EvalAction(this.guiDebugger), 69);
        this.item(new FieldsAction(this.guiDebugger), 70);
        this.item(new LocalsAction(this.guiDebugger), 76);
        this.item(new PrintAction(this.guiDebugger), 80);
        this.add(this.menu);
    }

    void monitorMenu() {
        this.menu("Monitor", 78);
        this.check("where");
        this.check("locals");
        this.check("list");
        this.add(this.menu);
    }

    void check(final String command) {
        boolean present = false;
        final AJDebugger debugger = this.guiDebugger.getDebugger();
        Iterator iter = debugger.getMonitorRequests().iterator();
        while (iter.hasNext()) {
            MonitorRequest request = (MonitorRequest)iter.next();
            if (!request.getCommand().equals(command)) continue;
            present = true;
        }
        final JCheckBoxMenuItem item = new JCheckBoxMenuItem(command, present);
        item.setMnemonic(this.mnemonic(command));
        item.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                if (item.isSelected()) {
                    try {
                        debugger.monitorCommand(command);
                    }
                    catch (Exception ee) {
                        item.setSelected(false);
                    }
                } else {
                    this.unmonitorCommand(command);
                }
            }

            void unmonitorCommand(String _command) {
                Iterator _iter = debugger.getMonitorRequests().iterator();
                while (_iter.hasNext()) {
                    MonitorRequest request = (MonitorRequest)_iter.next();
                    if (!request.getCommand().equals(_command)) continue;
                    try {
                        debugger.unmonitorCommand(request.getNumber());
                    }
                    catch (Exception ee) {
                        item.setSelected(true);
                    }
                    return;
                }
            }
        });
        this.menu.add(item);
    }

    int mnemonic(String command) {
        int N = command.length();
        int M = this.menu.getItemCount();
        int i = 0;
        while (i < N) {
            char c = command.charAt(i);
            boolean there = false;
            int j = 0;
            while (j < M) {
                if (this.menu.getItem(j).getMnemonic() == c) {
                    there = true;
                }
                ++j;
            }
            if (!there) {
                return c;
            }
            ++i;
        }
        return -1;
    }

    void helpMenu() {
        this.menu("Help", 84);
        this.add(Box.createHorizontalGlue());
        this.item(new HelpAction(this.guiDebugger), 112);
        this.item(new AboutAction(this.guiDebugger), 113);
        this.add(this.menu);
    }

    ThreadGetter threadGetterToSuspend() {
        return new ThreadGetter(){

            public String getThread() {
                return Dialogs.showSuspendDialog();
            }
        };
    }

    ThreadGetter threadGetterToResume() {
        return new ThreadGetter(){

            public String getThread() {
                return Dialogs.showResumeDialog();
            }
        };
    }

    ThreadGetter threadGetterToWhere() {
        return new ThreadGetter(){

            public String getThread() {
                return Dialogs.showWhereDialog();
            }
        };
    }

    void sep() {
        this.menu.addSeparator();
    }

    void menu(String title, int mnemonic) {
        this.menu = new JMenu(title);
        this.menu.setMnemonic(mnemonic);
    }

    void item(AbstractActionStruct a, int key) {
        String title = a.getValue("label") + "";
        int mnemonic = key;
        KeyStroke keyStroke = KeyStroke.getKeyStroke(a.key(), a.mask());
        if (!jdk.equals("1.3")) {
            this.item = new JMenuItem((String)a.getValue("label"), (Icon)a.getValue("icon"));
            this.item.addActionListener(a);
        }
        this.item.setText(title);
        this.item.setMnemonic(mnemonic);
        this.item.setAccelerator(keyStroke);
        this.menu.add(this.item);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Menu Test");
        f.setJMenuBar(new AJMenuBar(null));
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.out.println("Exiting...");
                System.exit(0);
            }
        });
        f.pack();
        ((Component)f).setVisible(true);
    }

    public String toString() {
        return AJMenuBar.d();
    }

    public static String d() {
        return "Menu Bar";
    }
}

