/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.io.File;
import org.aspectj.debugger.gui.AJLineMapper;
import org.aspectj.debugger.gui.DeclarationComparator;
import org.aspectj.debugger.gui.MethodComparator;
import org.aspectj.debugger.gui.Util;
import org.aspectj.tools.ide.Declaration;

public class AJDecParser {
    public static final int BAD = -1;

    public static int getMethodLineNumber(String fileName, String methodName) {
        if (fileName == null) {
            return -1;
        }
        Util.debug("Looking for methodName=" + methodName + " in " + fileName);
        String fullName = new File(fileName).getAbsolutePath();
        Declaration[] decs = AJLineMapper.symbolManager.getDeclarations(fullName);
        if (decs == null) {
            return -1;
        }
        MethodComparator c = new MethodComparator();
        int i = 0;
        while (i < decs.length) {
            int result = AJDecParser.getBeginLine(decs[i], methodName, c);
            if (result != -1) {
                return result;
            }
            ++i;
        }
        return -1;
    }

    public static int getBeginLine(Declaration dec, String s, DeclarationComparator c) {
        if (c.compare(dec, s)) {
            return dec.getBeginLine();
        }
        Declaration[] decs = dec.getDeclarations();
        int result = -1;
        int i = 0;
        while (i < decs.length) {
            result = AJDecParser.getBeginLine(decs[i], s, c);
            if (result != -1) {
                return result;
            }
            ++i;
        }
        return -1;
    }
}

