/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.gui;

import java.util.StringTokenizer;
import org.aspectj.debugger.gui.MethodHelper;
import org.aspectj.debugger.gui.MethodNode;
import org.aspectj.tools.ide.Declaration;

public class AJCMethodHelper
implements MethodHelper {
    private Declaration dec;
    private int type = Integer.MIN_VALUE;

    public AJCMethodHelper(Declaration dec) {
        this.dec = dec;
    }

    public String getRealName() {
        return this.dec.getSignature();
    }

    public String getDisplayName() {
        return this.getRealName();
    }

    public String getToolTipText() {
        return this.dec.getFullSignature();
    }

    public String getClassName() {
        return this.dec.getDeclaringType();
    }

    public String getRelativePath() {
        return this.dec.getFilename();
    }

    public int getLine() {
        return this.dec.getBeginLine();
    }

    public String getBreakpoint() {
        return this.getPackagePrefix() + this.dec.getDeclaringType() + "." + this.breakpointSignature();
    }

    private String getPackagePrefix() {
        String packageName = this.dec.getPackageName();
        if (packageName == null || packageName.equals("")) {
            return "";
        }
        return packageName + ".";
    }

    public Declaration getDec() {
        return this.dec;
    }

    private String breakpointSignature() {
        return this.dec.getSignature();
    }

    public int getType() {
        return this.type >= 0 ? this.type : (this.type = this._getType());
    }

    public int _getType() {
        StringTokenizer tok = new StringTokenizer(this.dec.getFullSignature());
        boolean isStatic = false;
        boolean isPublic = false;
        boolean isPrivate = false;
        boolean isProtected = false;
        boolean isInit = false;
        boolean isCtr = false;
        if (this.getRealName().startsWith("new(") || this.getRealName().equals("<init>")) {
            isCtr = true;
        }
        while (tok.hasMoreTokens()) {
            String token = tok.nextToken();
            if (token.indexOf("(") != -1) break;
            if (token.equals("static")) {
                isStatic = true;
            }
            if (token.equals("public")) {
                isPublic = true;
            }
            if (token.equals("protected")) {
                isProtected = true;
            }
            if (!token.equals("private")) continue;
            isPrivate = true;
        }
        return MethodNode.getType(isCtr, isStatic, isPublic, isPrivate, isProtected);
    }
}

