/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import java.util.AbstractList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.debugger.base.CommandReceiver;
import org.aspectj.debugger.base.Debugger;
import org.aspectj.debugger.base.DebuggerException;
import org.aspectj.debugger.base.InvalidIdentException;
import org.aspectj.debugger.base.NoVMException;
import org.aspectj.debugger.base.Options;
import org.aspectj.debugger.base.ParseException;
import org.aspectj.debugger.base.SyntaxException;
import org.aspectj.debugger.request.Request;

public class Parser {
    private CommandReceiver debugger;
    private StringTokenizer tok;
    private Request lastRequest;
    private String command;
    private String lastCommand = "";
    private static final String[] commands = new String[]{"break", "catch", "class", "classes", "classpath", "clear", "connect", "cont", "deport", "dir", "down", "dump", "eval", "exclude", "exit", "fields", "help", "ignore", "import", "interrupt", "kill", "list", "locals", "lock", "ls", "methods", "monitor", "next", "object", "print", "pwd", "quit", "read", "resume", "run", "set", "step", "stepi", "stop", "suspend", "thread", "threadgroup", "threadgroups", "threadlocks", "threads", "tostring", "trace", "unmonitor", "untrace", "unwatch", "up", "use", "version", "view", "watch", "where", "workingdir", "?"};
    private static Map aliases = new HashMap();
    private static String[] noVmCommands;
    public static final String THREAD = "Thread number not specified.";
    public static final String KILL = "Usage: kill <thread id> <throwable>";
    public static final String PRINT = "No objects specified.";
    public static final String DUMP = "No objects specified.";
    public static final String EVAL = "No objects specified.";
    public static final String SET = "Usage: set <lvalue> = <expr>";
    public static final String CLASS = "No class specified.";
    public static final String METHODS = "No class specified.";
    public static final String FIELDS = "No class specified.";
    public static final String THREADGROUP = "Threadgroup name not specified.";
    public static final String CATCH = "Threadgroup name not specified.";
    public static final String WATCH = "watch [access|all] ...";
    public static final String UNWATCH = "unwatch [access|all] ...";
    public static final String UNMONITOR = "usage: unmonitor <monitor#>";
    public static final String READ = "usage: read <command-filename>";
    public static final String UNKOWN_COMMAND = "Unkown command, type 'help' for more help";
    public static final String CLASS_METHOD = "<class>.<method>";
    public static final String SOURCE_LINE = "<source>:<line>";
    public static final String SOURCE_LINE_NO_NUMBER = "<source>:<line> (<line was not a number)";
    public static final String CLASS_LINE = "<class>:<line>";
    public static final String CLASS_LINE_NO_NUMBER = "<class>:<line> (<line was not a number)";
    public static final String END_OF_LINE = "Unexpected end of line";
    public static final String EXPECTING_NUMBER = "Expecting a number";
    public static final String IMPORT = "Usage: import <path>";
    public static final String DEPORT = "Usage: deport <path>";
    private CommandCompletor completor = new CommandCompletor(commands);

    private String alias(String line) {
        Object alias = aliases.get(line);
        return alias != null ? alias + "" : line;
    }

    public Parser(CommandReceiver debugger) {
        this.debugger = debugger;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object parse(String line) throws ParseException, NoVMException, DebuggerException {
        Object result;
        this.command = this.alias(line);
        this.tok = new StringTokenizer(line);
        if (!this.tok.hasMoreTokens()) {
            return null;
        }
        String first = this.tok.nextToken().trim();
        first = this.completor.getCommand(first);
        this.checkRunningVM(first);
        if (first.endsWith("!")) {
            first = first.substring(0, first.length() - 1);
        }
        if (first.equals("threads")) {
            String threadGroup = this.question();
            result = this.debugger.threadsCommand(threadGroup);
        } else if (first.equals("thread")) {
            String thread = this.next(THREAD);
            result = this.debugger.threadCommand(thread);
        } else if (first.equals("suspend")) {
            List threads = this.listStar();
            result = this.debugger.suspendCommand(threads);
        } else if (first.equals("resume")) {
            List threads = this.listStar();
            result = this.debugger.resumeCommand(threads);
        } else if (first.equals("where")) {
            String thread = this.question();
            result = this.debugger.whereCommand(thread);
        } else if (first.equals("up")) {
            int num = this.integerStar();
            if (num == -1) {
                num = 1;
            }
            result = this.debugger.upCommand(num);
        } else if (first.equals("down")) {
            int num = this.integerStar();
            if (num == -1) {
                num = 1;
            }
            result = this.debugger.downCommand(num);
        } else if (first.equals("kill")) {
            String thread = this.next(KILL);
            String expr = this.rest(KILL);
            result = this.debugger.killCommand(thread, expr);
        } else if (first.equals("interrupt")) {
            String thread = this.next();
            result = this.debugger.interruptCommand(thread);
        } else if (first.equals("print")) {
            String expr = this.rest("No objects specified.");
            result = this.debugger.printCommand(expr);
        } else if (first.equals("dump")) {
            String expr = this.rest("No objects specified.");
            result = this.debugger.dumpCommand(expr);
        } else if (first.equals("eval")) {
            String expr = this.rest("No objects specified.");
            result = this.debugger.evalCommand(expr);
        } else if (first.equals("set")) {
            String lvalue = this.ident(SET);
            String eq = this.next(SET);
            String expr = "";
            expr = eq.indexOf("=") == -1 ? eq : this.rest(SET);
            result = this.debugger.setCommand(lvalue, expr);
        } else if (first.equals("locals")) {
            result = this.debugger.localsCommand();
        } else if (first.equals("classes")) {
            result = this.debugger.classesCommand();
        } else if (first.equals("class")) {
            String classID = this.next("No class specified.");
            result = this.debugger.classCommand(classID);
        } else if (first.equals("methods")) {
            String classID = this.next("No class specified.");
            result = this.debugger.methodsCommand(classID);
        } else if (first.equals("fields")) {
            String classID = this.next("No class specified.");
            result = this.debugger.fieldsCommand(classID);
        } else if (first.equals("threadgroups")) {
            result = this.debugger.threadGroupsCommand();
        } else if (first.equals("threadgroup")) {
            String threadgroup = this.next("Threadgroup name not specified.");
            result = this.debugger.threadGroupCommand(threadgroup);
        } else if (first.equals("stop") || first.equals("break")) {
            result = this.stop(this.restStar());
        } else if (first.equals("clear")) {
            result = this.clear(this.restStar());
        } else if (first.equals("catch")) {
            String classID = this.next("Threadgroup name not specified.");
            result = this.debugger.catchCommand(classID);
        } else if (first.equals("ignore")) {
            String classID = this.next();
            result = this.debugger.ignoreCommand(classID);
        } else if (first.equals("watch")) {
            String accessOrAll = this.next(WATCH);
            ClassMethod cm = this.classMethod(this.rest(WATCH));
            if (accessOrAll.equals("access")) {
                result = this.debugger.watchAccessCommand(cm.className, cm.methodName);
            } else {
                if (!accessOrAll.equals("all")) throw new SyntaxException(WATCH);
                result = this.debugger.watchAllCommand(cm.className, cm.methodName);
            }
        } else if (first.equals("unwatch")) {
            String accessOrAll = this.next(UNWATCH);
            ClassMethod cm = this.classMethod(this.rest(UNWATCH));
            if (accessOrAll.equals("access")) {
                result = this.debugger.unwatchAccessCommand(cm.className, cm.methodName);
            } else {
                if (!accessOrAll.equals("all")) throw new SyntaxException(UNWATCH);
                result = this.debugger.unwatchAllCommand(cm.className, cm.methodName);
            }
        } else if (first.equals("trace")) {
            this.eat("methods");
            String thread = this.next();
            result = this.debugger.traceMethodsCommand(thread);
        } else if (first.equals("untrace")) {
            this.eat("methods");
            String thread = this.next();
            result = this.debugger.untraceMethodsCommand(thread);
        } else if (first.equals("step")) {
            result = this.star().equals("up") ? this.debugger.stepUpCommand() : this.debugger.stepCommand();
        } else if (first.equals("stepi")) {
            result = this.debugger.stepiCommand();
        } else if (first.equals("next")) {
            result = this.debugger.nextCommand();
        } else if (first.equals("cont")) {
            result = this.debugger.contCommand();
        } else if (first.equals("exclude")) {
            List classes = this.listStar();
            result = this.debugger.excludeCommand(classes);
        } else if (first.equals("classpath")) {
            result = this.debugger.classpathCommand();
        } else if (first.equals("lock")) {
            String expr = this.rest();
            result = this.debugger.lockCommand(expr);
        } else if (first.equals("threadlocks")) {
            String thread = this.next();
            result = this.debugger.threadlocksCommand(thread);
        } else if (first.equals("!!")) {
            System.err.println("lastCommand=" + this.lastCommand);
            result = this.debugger.bangBangCommand(this.lastCommand);
        } else if (first.equals("help") || first.equals("?")) {
            result = this.debugger.helpCommand();
        } else if (first.equals("version")) {
            result = this.debugger.versionCommand();
        } else if (first.equals("exit") || first.equals("quit")) {
            result = this.debugger.quitCommand();
        } else if (first.equals("run")) {
            Options opts = this.debugger.getOptions();
            opts.fill(this.restStar());
            result = this.debugger.runCommand(opts);
        } else if (first.equals("connect")) {
            result = this.debugger.connectCommand();
        } else if (first.equals("use")) {
            String sourcePath = this.restStar();
            result = this.debugger.useCommand(sourcePath);
        } else if (first.equals("workingdir")) {
            String workingdirPath = this.restStar();
            result = this.debugger.workingdirCommand(workingdirPath);
        } else if (first.equals("list")) {
            String sourceName = this.star();
            int startLine = -1;
            int endLine = -1;
            if (sourceName.equals("")) {
                this.mandateRunningVM("list");
                result = this.debugger.listCommand();
            } else {
                startLine = this.isNumber(sourceName) ? Integer.parseInt(sourceName) : this.integerStar();
                endLine = this.integerStar();
                result = startLine == -1 ? this.debugger.listCommand(sourceName) : (endLine == -1 ? this.debugger.listCommand(sourceName, startLine) : this.debugger.listCommand(sourceName, startLine, endLine));
            }
        } else if (first.equals("monitor")) {
            String command = this.restStar();
            if (command.equals("")) {
                result = this.debugger.monitorCommand();
            } else {
                command = this.completor.getCommand(command);
                result = this.debugger.monitorCommand(command);
            }
        } else if (first.equals("unmonitor")) {
            int number = this.integer(this.rest(UNMONITOR), UNMONITOR);
            result = this.debugger.unmonitorCommand(number);
        } else if (first.equals("read")) {
            String fileName = this.rest(READ);
            result = this.debugger.readCommand(fileName);
        } else if (first.equals("import")) {
            String path = this.rest(IMPORT);
            result = this.debugger.importCommand(path);
        } else if (first.equals("deport")) {
            String path = this.rest(DEPORT);
            result = this.debugger.deportCommand(path);
        } else if (first.equals("view")) {
            String source = this.rest();
            result = this.debugger.viewCommand(source);
        } else if (first.equals("tostring")) {
            result = this.debugger.tostringCommand();
        } else if (first.equals("pwd")) {
            result = this.debugger.pwdCommand();
        } else {
            if (!first.equals("ls") && !first.equals("dir")) throw new ParseException(UNKOWN_COMMAND);
            result = this.debugger.lsCommand(this.rest());
        }
        this.lastCommand = this.command;
        return result;
    }

    private boolean equals(String first, String str) {
        return first.equalsIgnoreCase(str);
    }

    private void mandateRunningVM(String command) throws ParseException {
        this.checkRunningVM(command, true);
    }

    private void checkRunningVM(String first) throws ParseException {
        this.checkRunningVM(first, false);
    }

    private void checkRunningVM(String first, boolean force) throws ParseException {
        if (((Debugger)this.debugger).isRunning()) {
            return;
        }
        if (!force) {
            if (this.debugger.getOptions().isSet("extra")) {
                return;
            }
            int N = noVmCommands.length;
            int i = 0;
            while (i < N) {
                if (noVmCommands[i].equals(first)) {
                    return;
                }
                ++i;
            }
        }
        String msg = "Command '" + first + "' is not valid until the VM is started " + "with the 'run' command";
        throw new ParseException(msg);
    }

    private boolean isNumber(String str) {
        try {
            Integer.parseInt(str);
            return true;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private String star() {
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken().trim();
        }
        return "";
    }

    private String restStar() {
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken("").trim();
        }
        return "";
    }

    private String eat(String str) throws ParseException {
        if (this.tok.hasMoreTokens()) {
            return this.next();
        }
        throw new ParseException("Expecting '" + str + "'; found an end-of-line");
    }

    private Object stop(String theRest) throws ParseException, NoVMException, DebuggerException {
        return this.parseBreakpoint(theRest, true);
    }

    private Object clear(String theRest) throws ParseException, NoVMException, DebuggerException {
        return this.parseBreakpoint(theRest, false);
    }

    private Object parseBreakpoint(String theRest, boolean isStop) throws ParseException, NoVMException, DebuggerException {
        try {
            String rest = theRest;
            rest = rest.trim();
            if (rest.equals("") || rest.length() == 0) {
                return isStop ? this.debugger.stopCommand() : this.debugger.clearCommand();
            }
            if (rest.startsWith("at ") || rest.startsWith("in ") || rest.startsWith("on ")) {
                theRest = rest = rest.substring(3).trim();
            }
            String classOrSource = "";
            int index = 0;
            boolean isMethod = true;
            int i = rest.length() - 1;
            while (i >= 0) {
                if (this.isOneOf(rest.charAt(i), ":; ")) {
                    index = i;
                    isMethod = false;
                    break;
                }
                if (rest.charAt(i) == '(') {
                    index = i;
                    isMethod = true;
                    break;
                }
                --i;
            }
            classOrSource = index > 0 ? rest.substring(0, index).trim() : rest;
            rest = index < rest.length() ? rest.substring(index).trim() : "";
            if (isMethod |= rest.length() == 0 || rest.startsWith("(")) {
                int ilastDot = classOrSource.length() - 1;
                while (ilastDot > 0) {
                    if (classOrSource.charAt(ilastDot) == '.') break;
                    --ilastDot;
                }
                String className = theRest.substring(0, ilastDot);
                String methodProto = theRest.substring(ilastDot + 1);
                return isStop ? this.debugger.stopInCommand(className, methodProto) : this.debugger.clearInCommand(className, methodProto);
            }
            if (this.isOneOf(rest.charAt(0), ":;,")) {
                rest = rest.substring(1);
            }
            if (classOrSource.endsWith(".java")) {
                int integer = this.integer(rest.trim());
                return isStop ? this.debugger.stopOnCommand(classOrSource, integer) : this.debugger.clearOnCommand(classOrSource, integer);
            }
            int integer = this.integer(rest);
            return isStop ? this.debugger.stopAtCommand(classOrSource, integer) : this.debugger.clearAtCommand(classOrSource, integer);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ParseException("Unexpected command");
        }
    }

    private boolean isOneOf(char c, String s) {
        int i = 0;
        while (i < s.length()) {
            if (c == s.charAt(i)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ClassMethod classMethod(String rest) throws ParseException {
        try {
            return this._classMethod(rest);
        }
        catch (Exception exception) {
            throw new SyntaxException(CLASS_METHOD);
        }
    }

    private ClassMethod _classMethod(String rest) throws ParseException {
        int iparen = rest.indexOf("(");
        String className = "";
        String methodName = "";
        int idot = -1;
        if (iparen == -1) {
            idot = rest.lastIndexOf(".");
        } else {
            idot = iparen;
            while (idot > 0) {
                if (rest.charAt(idot) == '.') break;
                --idot;
            }
        }
        if (idot == -1) {
            throw new SyntaxException(CLASS_METHOD);
        }
        className = rest.substring(0, idot);
        methodName = rest.substring(idot + 1);
        return new ClassMethod(className, methodName);
    }

    private SourceLine sourceLine(String rest) throws ParseException {
        StringTokenizer colonTok = new StringTokenizer(rest, ":");
        int icolon = rest.lastIndexOf(":");
        if (icolon == -1) {
            throw new SyntaxException(SOURCE_LINE);
        }
        try {
            String sourceName = rest.substring(0, icolon);
            String lineName = rest.substring(icolon + 1);
            int line = Integer.parseInt(lineName);
            return new SourceLine(sourceName, line);
        }
        catch (NoSuchElementException e) {
            throw new SyntaxException(SOURCE_LINE);
        }
        catch (NumberFormatException nfe) {
            throw new SyntaxException(SOURCE_LINE_NO_NUMBER);
        }
    }

    private ClassLine classLine(String rest) throws ParseException {
        StringTokenizer colonTok = new StringTokenizer(rest, ":");
        int icolon = rest.lastIndexOf(":");
        if (icolon == -1) {
            throw new SyntaxException(SOURCE_LINE);
        }
        try {
            String className = rest.substring(0, icolon);
            String lineName = rest.substring(icolon + 1);
            int line = Integer.parseInt(lineName);
            return new ClassLine(className, line);
        }
        catch (NoSuchElementException e) {
            throw new SyntaxException(CLASS_LINE);
        }
        catch (NumberFormatException nfe) {
            throw new SyntaxException(CLASS_LINE_NO_NUMBER);
        }
    }

    private String dump() {
        if (this.tok.hasMoreTokens()) {
            String str = this.tok.nextToken("").trim();
            this.tok = new StringTokenizer(str);
            return str;
        }
        return "";
    }

    private String nextStar() {
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken().trim();
        }
        return "";
    }

    private String next(String s) throws ParseException {
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken().trim();
        }
        throw new ParseException(s);
    }

    private String next() throws ParseException {
        return this.next(END_OF_LINE);
    }

    private String question() {
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken("").trim();
        }
        return "";
    }

    private String rest() throws ParseException {
        return this.rest(END_OF_LINE);
    }

    private String rest(String s) throws ParseException {
        if (this.tok.hasMoreTokens()) {
            return this.tok.nextToken("").trim();
        }
        throw new ParseException(s);
    }

    private List listStar() {
        Vector<String> list = new Vector<String>();
        while (this.tok.hasMoreTokens()) {
            list.add(this.tok.nextToken().trim());
        }
        return list;
    }

    private int integer() throws ParseException {
        return this.integer(this.rest());
    }

    private int integer(String num) throws ParseException {
        return this.integer(num, null);
    }

    private int integer(String rest, String msg) throws ParseException {
        if (rest != null) {
            try {
                return Integer.parseInt(rest.trim());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new ParseException(msg == null ? EXPECTING_NUMBER : msg);
    }

    private int integerStar() throws ParseException {
        String next = this.nextStar();
        if (next.equals("")) {
            return -1;
        }
        try {
            return Integer.parseInt(next.trim());
        }
        catch (NumberFormatException numberFormatException) {
            throw new ParseException(EXPECTING_NUMBER);
        }
    }

    private boolean ws(String s) {
        int i = 0;
        while (i < s.length()) {
            if (Character.isWhitespace(s.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private String ident(String s) throws ParseException {
        try {
            return this.ident();
        }
        catch (ParseException parseException) {
            throw new ParseException(s);
        }
    }

    private String ident() throws ParseException {
        String token = this.next();
        if (!Character.isJavaIdentifierStart(token.charAt(0))) {
            throw new InvalidIdentException(token);
        }
        int i = 1;
        while (i < token.length()) {
            char c = token.charAt(i);
            if (!Character.isJavaIdentifierPart(c) && c != '.' && c != '[' && c != ']') {
                throw new InvalidIdentException(token);
            }
            ++i;
        }
        return token;
    }

    public String command() {
        return this.command;
    }

    static {
        String[] strings = new String[]{"break", "b", "cont", "c", "down", "d", "help", "h", "list", "l", "monitor", "m", "next", "n", "quit", "q", "read", "r", "step", "s", "stepi", "si", "step up", "su", "up", "u", "where", "w"};
        int i = 0;
        while (i < strings.length) {
            aliases.put(strings[i + 1], strings[i]);
            i += 2;
        }
        noVmCommands = new String[]{"catch", "clear", "dir", "exit", "help", "ignore", "import", "list", "ls", "pwd", "quit", "read", "run", "sourcepath", "stop", "unwatch", "use", "version", "watch", "?"};
    }

    class CommandCompletor {
        String[] commands;

        public CommandCompletor(String[] commands) {
            this.commands = commands;
        }

        public String getCommand(String start) throws ParseException {
            return this.getCommand(start, true);
        }

        public String getCommand(String start, boolean throwException) throws ParseException {
            Object match = aliases.get(start);
            if (match != null) {
                return match + "";
            }
            Vector<String> matches = new Vector<String>();
            int i = 0;
            while (i < this.commands.length) {
                if (this.commands[i].equals(start)) {
                    return start;
                }
                if (this.commands[i].startsWith(start)) {
                    matches.add(this.commands[i]);
                }
                ++i;
            }
            if (matches.size() == 0) {
                if (start.endsWith("!")) {
                    String str = this.getCommand(start.substring(0, start.length() - 1), false);
                    if (str != null) {
                        return str + "!";
                    }
                    throwException = true;
                }
                if (throwException) {
                    throw new ParseException("No command begins with the prefix '" + start + "'");
                }
                return null;
            }
            if (matches.size() > 1) {
                if (throwException) {
                    String msg = "The prefix '" + start + "' has the possible completions:\n";
                    Iterator iter = ((AbstractList)matches).iterator();
                    while (iter.hasNext()) {
                        msg = msg + "\t" + iter.next() + "\n";
                    }
                    throw new ParseException(msg);
                }
                return null;
            }
            return matches.get(0) + "";
        }
    }

    static class ClassLine {
        String className;
        int line;

        public ClassLine(String className, int line) {
            this.className = className;
            this.line = line;
        }
    }

    static class SourceLine {
        String sourceName;
        int line;

        public SourceLine(String sourceName, int line) {
            this.sourceName = sourceName;
            this.line = line;
        }
    }

    static class ClassMethod {
        String className;
        String methodName;

        public ClassMethod(String className, String methodName) {
            this.className = className;
            this.methodName = methodName;
        }
    }
}

