/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.aspectj.debugger.base.Debug;
import org.aspectj.debugger.base.Debugger;

public class Options {
    public static final String helpString = "Usage: ajdb <options> <class> <arguments>\n\nwhere options include:\n    -help             print out this message and exit\n    -sourcepath <directory>\n                      directory in which to look for source files\n    -read <file>      read the startup file\n    -gui              start up in GUI mode\n    -extra            enable extra features unique to ajdb\n    -workingdir       set the user's workingdir\noptions forwarded to debuggee process:\n    -v -verbose[:class|gc|jni]\n                      turn on verbose mode\n    -D<name>=<value>  set a system property\n    -classpath <directories separated by \";\">\n                      list directories in which to look for classes\n    -X<option>        non-standard target VM option\n\n<class> is the name of the class to begin debugging\n<arguments> are the arguments passed to the main() method of <class>\n\nFor command help type 'help' at jdb prompt\n";
    private HashMap opts = new HashMap();
    private String className = "";
    private String commandLine = "";
    public static final String[] javaArgs = new String[]{"classpath", "v", "verbose", "verbose:class", "verbose:gc", "verbose:jni", "X", "D"};

    public Options() {
        this.set("extra");
    }

    public static final String helpString() {
        return helpString;
    }

    public String getClassName() {
        return this.className;
    }

    public String getCommandLine() {
        return this.commandLine;
    }

    public String getFullCommandLine() {
        String line = "";
        if (!Options.empty(this.className)) {
            line = line + this.className;
        }
        if (!Options.empty(this.commandLine)) {
            line = line + " " + this.commandLine;
        }
        line = line.trim();
        System.out.println("line=" + line);
        return line;
    }

    private static boolean empty(String str) {
        return str == null || "".equals(str.trim());
    }

    public void fill(String str) {
        Vector<String> v = new Vector<String>();
        StringTokenizer tok = new StringTokenizer(str);
        while (tok.hasMoreTokens()) {
            String t = tok.nextToken();
            if (t.startsWith("\"")) {
                boolean done = t.endsWith("\"");
                while (!done && tok.hasMoreTokens()) {
                    String end = tok.nextToken().trim();
                    t = t + end;
                    if (!end.endsWith("\"")) continue;
                    done = true;
                }
            }
            v.add(t);
        }
        String[] args = new String[v.size()];
        Iterator iter = ((AbstractList)v).iterator();
        int i = 0;
        while (i < args.length) {
            args[i] = v.get(i) + "";
            ++i;
        }
        this.fill(args);
    }

    public void fill(String[] args) {
        this.realFill(this.removeNoWarn(args));
        Debug.setOptions(this);
    }

    private String[] removeNoWarn(String[] args) {
        int i = 0;
        while (i < args.length) {
            String opt = args[i];
            if (this.opt(opt, "nowarn")) {
                String[] newArgs = new String[args.length - 1];
                System.arraycopy(args, 0, newArgs, 0, i);
                System.arraycopy(args, i + 1, newArgs, i, args.length - i - 1);
                this.set("nowarn");
                return newArgs;
            }
            ++i;
        }
        return args;
    }

    private void realFill(String[] args) {
        int i = 0;
        String opt = "";
        String arg = "";
        while (i < args.length) {
            if (this.opt(opt = args[i++], "extra")) {
                this.set("extra");
                continue;
            }
            if (this.opt(opt, "now")) {
                this.set("now");
                continue;
            }
            if (this.opt(opt, "noextra")) {
                this.unset("extra");
                continue;
            }
            if (this.opt(opt, "nowarn")) {
                this.set("nowarn");
                continue;
            }
            if (this.opt(opt, "help")) {
                this.help();
                continue;
            }
            if (this.opt(opt, "sourcepath")) {
                this.check(args, i, "-sourcepath");
                this.set("sourcepath", args[i++]);
                continue;
            }
            if (this.opt(opt, "attach")) {
                this.check(args, i, "-attach");
                this.set("attach", args[i++]);
                continue;
            }
            if (this.opt(opt, "listen")) {
                this.check(args, i, "-listen");
                this.set("listen", args[i++]);
                continue;
            }
            if (this.opt(opt, "listenany")) {
                this.set("listenany");
                continue;
            }
            if (this.opt(opt, "launch")) {
                this.set("launch");
                continue;
            }
            if (this.opt(opt, "connect")) {
                this.check(args, i, "-connect");
                this.set("connect", args[i++]);
                continue;
            }
            if (this.opt(opt, "dbgtrace")) {
                if (this.isArg(args, i + 1)) {
                    this.set("dbgtrace", args[i++]);
                    continue;
                }
                this.set("dbgtrace");
                continue;
            }
            if (this.opt(opt, "thotspot")) {
                this.set("thotspot");
                continue;
            }
            if (this.opt(opt, "tclassic")) {
                this.set("tclassic");
                continue;
            }
            if (this.opt(opt, "v")) {
                this.set("v");
                continue;
            }
            if (this.opt(opt, "verbose")) {
                this.set("verbose");
                continue;
            }
            if (this.opt(opt, "verbose:class")) {
                this.set("verbose:class");
                continue;
            }
            if (this.opt(opt, "verbose:gc")) {
                this.set("verbose:gc");
                continue;
            }
            if (this.opt(opt, "verbose:jni")) {
                this.set("verbose:jni");
                continue;
            }
            if (this.opt(opt, "demo")) {
                this.set("demo");
                Debugger.demoMode = true;
                continue;
            }
            if (this.opt(opt, "classpath")) {
                this.check(args, i, "-classpath");
                this.set("classpath", args[i++]);
                continue;
            }
            if (this.opt(opt, "workingdir")) {
                this.check(args, i, "-workingdir");
                this.set("workingdir", args[i++]);
                continue;
            }
            if (this.opt(opt, "read")) {
                this.check(args, i, "-read");
                this.set("read", args[i++]);
                continue;
            }
            if (this.opt(opt, "debug")) {
                this.set("debug");
                continue;
            }
            if (opt.startsWith("-D")) {
                arg = this.strip("-D", opt, "<name>=<value>");
                if (arg.indexOf("\"") != -1) {
                    while (i < args.length) {
                        String next = args[i++];
                        arg = arg + " " + next;
                        if (next.endsWith("\"")) break;
                    }
                }
                this.set("D", arg);
                continue;
            }
            if (opt.startsWith("-X")) {
                arg = this.strip("-X", opt, "<option>");
                this.set("X", arg);
                continue;
            }
            if (this.isArg(opt)) {
                this.warn(opt + " is not a valid option");
                this.set(this.deopt(opt));
                continue;
            }
            this.className = opt;
            while (i < args.length) {
                this.commandLine = this.commandLine + " " + args[i++];
            }
        }
    }

    private boolean opt(String opt, String str) {
        return opt.equals("-" + str) || opt.equals("--" + str);
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public void setMainClass(String mainClass) {
        this.setClassName(mainClass);
    }

    public void setClassPath(String classPath) {
        this.set("classpath", classPath);
    }

    public void setSourcePath(String sourcePath) {
        this.set("sourcepath", sourcePath);
    }

    public String getJavaArgs() {
        String args = "";
        if (this.isSet("thotspot")) {
            args = args + "-hotspot";
        } else if (this.isSet("tclassic")) {
            args = args + "-classic";
        }
        int i = 0;
        while (i < javaArgs.length) {
            if (this.isSet(javaArgs[i])) {
                args = args + " " + this.format(javaArgs[i]);
            }
            ++i;
        }
        return args.trim();
    }

    public String deopt(String opt) {
        int i = 0;
        while (i < opt.length()) {
            if (opt.charAt(i) != '-' && opt.length() >= i) {
                return opt.substring(i);
            }
            ++i;
        }
        return opt;
    }

    public String opt(String opt) {
        return "-" + opt;
    }

    public String format(String opt) {
        StringBuffer sb = new StringBuffer();
        if (this.isSet(opt)) {
            if (this.isListOption(opt)) {
                List list = (List)this.get(opt);
                if (null == list) {
                    this.warn(opt + " set but no list");
                } else {
                    Iterator it = list.iterator();
                    while (it.hasNext()) {
                        sb.append(" -" + opt + it.next());
                    }
                }
            } else {
                sb.append(this.opt(opt));
                String value = this.getOpt(opt);
                if (null != value && 0 < value.length()) {
                    sb.append(" ");
                    sb.append(value);
                }
            }
        }
        return sb.toString();
    }

    public boolean isSet(String opt) {
        return this.get(opt) != null;
    }

    public void set(String opt, String arg) {
        if (this.isListOption(opt)) {
            this.setListOption(opt, arg);
        } else {
            Object value;
            if (this.hasWhitespace(arg)) {
                arg = this.quote(arg);
            }
            if ((value = this.get(opt)) != null && !"debugging-for-jeff".equals(value)) {
                this.warn("Resetting option '" + opt + "' to '" + arg + "'.");
            }
            this.opts.put(opt, arg);
        }
    }

    public boolean isListOption(String opt) {
        return "D".equals(opt) || "X".equals(opt);
    }

    public void setListOption(String opt, String arg) {
        Object value;
        if (!this.isListOption(opt)) {
            String args = "(\"" + opt + "\", \"" + arg + "\")";
            this.warn("Options.setListOption" + args + ": not a list option");
            return;
        }
        if (this.hasWhitespace(arg)) {
            arg = this.quote(arg);
        }
        if (null == (value = this.opts.get(opt))) {
            value = new ArrayList();
            this.opts.put(opt, value);
        }
        List list = (List)value;
        list.add(arg);
    }

    public void set(String opt) {
        this.set(opt, "");
    }

    public void unset(String opt) {
        if (this.isListOption(opt)) {
            this.warn("Options.unset(\"" + opt + "\"): unsetting list");
        }
        this.set(opt, null);
    }

    public String quote(String arg) {
        return "\"" + arg + "\"";
    }

    public boolean hasWhitespace(String str) {
        int i = 0;
        while (i < str.length()) {
            if (Character.isWhitespace(str.charAt(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Object get(String opt) {
        return this.opts.get(opt);
    }

    public String getOpt(String opt) {
        return this.get(opt) + "";
    }

    public String toString() {
        return this.opts + "";
    }

    String strip(String start, String opt, String syntax) {
        int pos = start.length();
        String str = "";
        if (opt.length() < pos) {
            this.fail("Correct syntax: " + opt + syntax);
        } else {
            str = opt.substring(pos);
        }
        return str;
    }

    boolean isArg(String arg) {
        return arg != null && arg.startsWith("-");
    }

    boolean isArg(String[] args, int i) {
        return args != null && this.isArg(args[i]);
    }

    void check(String[] args, int i, String s) {
        if (args == null || args.length <= i || args[i] == null || this.isArg(args[i])) {
            this.fail("The option '" + s + "' needs an argument.");
        }
    }

    void fail(Object o) {
        this.outln(o);
        this.exit(1);
    }

    void warn(Object o) {
    }

    void exit(int i) {
        System.exit(i);
    }

    void help() {
        this.outln(Options.helpString());
    }

    void outln(Object o) {
        System.err.println(o);
    }
}

