/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ThreadReference;
import java.util.List;
import org.aspectj.debugger.base.Consts;
import org.aspectj.debugger.base.DebuggerException;

public class LockInformation {
    private ObjectReference objectRef;

    public LockInformation(ObjectReference objectRef) {
        this.objectRef = objectRef;
    }

    public ThreadReference getOwningThread() throws DebuggerException {
        try {
            return this.objectRef.owningThread();
        }
        catch (UnsupportedOperationException uoe) {
            throw new DebuggerException(uoe);
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebuggerException(itse);
        }
    }

    public List getWaitingThreads() throws DebuggerException {
        try {
            return this.objectRef.waitingThreads();
        }
        catch (UnsupportedOperationException uoe) {
            throw new DebuggerException(uoe);
        }
        catch (IncompatibleThreadStateException itse) {
            throw new DebuggerException(itse);
        }
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        try {
            void e;
            String str = "Object: " + this.objectRef + Consts.newline;
            str = str + "Owning thread: " + this.getOwningThread() + Consts.newline;
            str = str + "Waiting threads: " + this.getWaitingThreads();
            return e;
        }
        catch (DebuggerException debuggerException) {
            return "Thread thread has resumed.";
        }
    }
}

