/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.debugger.base;

import org.aspectj.debugger.base.Debugger;

public class Checker {
    private Debugger debugger;

    public Checker(Debugger debugger) {
        this.debugger = debugger;
    }

    public boolean check() {
        return this.checkJavaVersion() & this.checkRuntimeEnvironment();
    }

    protected boolean checkJavaVersion() {
        return this.checkClass("com.sun.jdi.VirtualMachine", "tools.jar required to run ajdb") && this.checkClass("com.sun.jdi.event.LocatableEvent", "tools.jar required to run ajdb") && this.checkClass("com.sun.jdi.VMDisconnectedException", "JDK 1.3 or later tools.jar required to run ajdb");
    }

    protected boolean checkClass(String className, String msg) {
        try {
            Class<?> c = Class.forName(className);
        }
        catch (ClassNotFoundException cnfe) {
            this.debugger.fatal(msg);
            return false;
        }
        return true;
    }

    protected boolean checkRuntimeEnvironment() {
        return true;
    }
}

