/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.ArrayList;
import java.util.Collections;
import org.aspectj.compiler.crosscuts.joinpoints.AndJpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.OrJpPlanner;
import org.aspectj.util.FuzzyBoolean;

public abstract class JpPlanner {
    public static final JpPlanner NO_PLANNER = new JpPlanner(){

        public FuzzyBoolean fastMatch(JoinPoint jp) {
            return FuzzyBoolean.NO;
        }
    };

    public boolean isStaticPlanner() {
        return false;
    }

    protected abstract FuzzyBoolean fastMatch(JoinPoint var1);

    public boolean alwaysMatches(JoinPoint jp) {
        return this.fastMatch(jp).alwaysTrue();
    }

    public boolean sometimesMatches(JoinPoint jp) {
        return this.fastMatch(jp).maybeTrue();
    }

    public JpPlan makePlan(JoinPoint jp) {
        FuzzyBoolean m = this.fastMatch(jp);
        if (m.alwaysTrue()) {
            return JpPlan.ANY_PLAN;
        }
        if (m.alwaysFalse()) {
            return JpPlan.NO_PLAN;
        }
        jp.getCompiler().internalError("bad fastMatch result from " + this);
        return JpPlan.NEVER_PLAN;
    }

    public JpPlanner or(JpPlanner other) {
        return new OrJpPlanner(this, other);
    }

    public JpPlanner and(JpPlanner other) {
        return new AndJpPlanner(this, other);
    }

    public JpPlanner not() {
        ArrayList<JpPlanner> newList = new ArrayList<JpPlanner>();
        newList.add(this);
        return new AndJpPlanner(Collections.EMPTY_LIST, newList);
    }

    public void walk(Object data) {
    }
}

