/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import java.util.Iterator;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CodeBody;
import org.aspectj.compiler.base.ast.ConstructorBody;
import org.aspectj.compiler.base.ast.ConstructorCallExpr;
import org.aspectj.compiler.base.ast.ConstructorDec;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Decs;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.InitializerDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.MovingWalker;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.TypeDec;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.base.ast.Walker;
import org.aspectj.compiler.crosscuts.joinpoints.CodeDecJp;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;

public class InitializationJp
extends CodeDecJp {
    public static final JoinPoint.Kind KIND = new JoinPoint.Kind("initialization", 32768);
    private ConstructorDec innerConstructorDec = null;
    private ConstructorDec outerConstructorDec = null;
    private InitializerDec instanceInitializer;

    public InitializationJp(ConstructorDec constructorDec) {
        super(constructorDec);
        constructorDec.getBytecodeTypeDec().getInitializerExecutionJoinPoints().add(this);
    }

    public JoinPoint.Kind getKind() {
        return KIND;
    }

    public TypeDec getEnclosingTypeDec() {
        return this.getCodeDec().getBytecodeTypeDec();
    }

    public ASTObject getSourceLocation() {
        return this.getEnclosingTypeDec().getBody();
    }

    public void setStmts(Stmts stmts) {
        this.makeInnerAndOuterConstructorDecs();
        this.innerConstructorDec.getBody().setStmts(stmts);
    }

    public Stmts getStmts() {
        this.makeInnerAndOuterConstructorDecs();
        return this.innerConstructorDec.getBody().getStmts();
    }

    public boolean needToImplement() {
        if (!super.needToImplement()) {
            return false;
        }
        return this.checkNoLocalTypes();
    }

    private boolean checkNoLocalTypes() {
        LocalFinderWalker w = new LocalFinderWalker(this.getCompiler());
        w.process(this.getStmts());
        return !w.foundLocal;
    }

    public void inlineBodies() {
        ConstructorDec origConstructorDec = (ConstructorDec)this.getCodeDec();
        this.outerConstructorDec = this.makeInitializer(origConstructorDec);
    }

    public void finishInline() {
        ConstructorDec origConstructorDec = (ConstructorDec)this.getCodeDec();
        ConstructorDec topDec = this.outerConstructorDec;
        origConstructorDec.setBody(topDec.getBody());
        if (this.instanceInitializer != null && this.instanceInitializer.getBody().getStmts().size() > 0) {
            BlockStmt initializerStmt = this.getAST().makeBlock(this.instanceInitializer.getBody().getStmts().copy());
            this.innerConstructorDec.getBody().getStmts().add(0, initializerStmt);
        }
        Formals oldFormals = origConstructorDec.getFormals();
        origConstructorDec.setFormals(topDec.getFormals());
        MovingWalker mover = new MovingWalker(this.getCompiler());
        int i = 0;
        while (i < oldFormals.size()) {
            FormalDec oldFormal = oldFormals.get(i);
            FormalDec newFormal = this.innerConstructorDec.getFormals().get(i);
            mover.addMapping(newFormal, oldFormal);
            newFormal.replaceWith(oldFormal);
            ++i;
        }
        mover.process(this.innerConstructorDec.getBody());
    }

    public void makeInnerAndOuterConstructorDecs() {
        if (this.outerConstructorDec != null) {
            return;
        }
        this.instanceInitializer = this.getEnclosingTypeDec().getSingleInitializerDec(false);
        Iterator i = this.getEnclosingTypeDec().getInitializerExecutionJoinPoints().iterator();
        while (i.hasNext()) {
            InitializationJp point = (InitializationJp)i.next();
            point.instanceInitializer = this.instanceInitializer;
            point.inlineBodies();
        }
        Iterator i2 = this.getEnclosingTypeDec().getInitializerExecutionJoinPoints().iterator();
        while (i2.hasNext()) {
            InitializationJp point = (InitializationJp)i2.next();
            point.finishInline();
        }
        this.getEnclosingTypeDec().getBody().remove(this.instanceInitializer);
    }

    ConstructorDec makeInitializer(ConstructorDec dec) {
        CopyWalker cw = new CopyWalker(this.getCompiler());
        ConstructorDec ret = new ConstructorDec(dec.getSourceLocation(), (Modifiers)cw.cp(dec.getModifiers()), (Formals)cw.cp(dec.getFormals()), (TypeDs)cw.cp(dec.getThrows()), (CodeBody)cw.cp(dec.getBody()));
        ConstructorBody body = (ConstructorBody)ret.getBody();
        ConstructorCallExpr thisCallExpr = body.getConstructorCall();
        if (thisCallExpr.getIsSuper()) {
            body.setStmts(body.getStmts().removeReturns());
            this.innerConstructorDec = ret;
            return ret;
        }
        ConstructorDec innerDec = this.makeInitializer(thisCallExpr.getConstructor().getConstructorDec());
        Formals oldFormals = ret.getFormals();
        CopyWalker copier = new CopyWalker(this.getCompiler());
        Formals newFormals = (Formals)copier.process(oldFormals);
        thisCallExpr = (ConstructorCallExpr)copier.process(thisCallExpr);
        thisCallExpr.getArgs().addAll(0, newFormals.makeExprs());
        thisCallExpr.setConstructor(innerDec.getConstructor());
        body.setConstructorCall(thisCallExpr);
        ret.setFormals(newFormals);
        Stmts stmts = body.getStmts();
        body.setStmts(this.getAST().makeStmts());
        this.inlineStmts(stmts, innerDec.getBody().getStmts());
        innerDec.getFormals().addAll(0, oldFormals);
        this.addUniquelyToBody(dec.getBytecodeTypeDec().getBody(), innerDec, thisCallExpr);
        return ret;
    }

    void inlineStmts(Stmts addStmts, Stmts baseStmts) {
        baseStmts.addAll(addStmts.removeReturns());
    }

    void addUniquelyToBody(Decs body, ConstructorDec dec, ConstructorCallExpr thisCallExpr) {
        AST ast = this.getAST();
        body.add(dec);
        VarDec cookieFormal = null;
        while (true) {
            int i = 0;
            while (i < body.size()) {
                ConstructorDec constructorDec;
                Dec idec = body.get(i);
                if (idec instanceof ConstructorDec && idec != dec && (constructorDec = (ConstructorDec)idec).getFormals().matches(dec.getFormals())) break;
                ++i;
            }
            if (i >= body.size()) break;
            if (cookieFormal == null) {
                cookieFormal = ast.makeFormal(this.getTypeManager().shortType.getArrayType(), "_ajcookie");
                dec.getFormals().add((FormalDec)cookieFormal);
                continue;
            }
            cookieFormal.setTypeD(cookieFormal.getType().getArrayType().makeTypeD());
        }
        if (cookieFormal != null) {
            thisCallExpr.getArgs().add(ast.forceCast(cookieFormal.getType(), ast.makeNull()));
        }
    }

    private class LocalFinderWalker
    extends Walker {
        public boolean foundLocal = false;

        public LocalFinderWalker(JavaCompiler c) {
            super(c);
        }

        public boolean preProcess(ASTObject o) {
            if (this.foundLocal) {
                return false;
            }
            if (o instanceof TypeDec) {
                InitializationJp.this.showError(o, "can't handle local classes in initializers with initialization join points (compiler limitation)");
                this.foundLocal = true;
                return false;
            }
            return true;
        }
    }
}

