/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.joinpoints;

import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.TypeDs;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AroundAdviceDec;
import org.aspectj.compiler.crosscuts.ast.AspectDec;
import org.aspectj.compiler.crosscuts.ast.BeforeAdviceDec;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;

public class AdvicePlan
extends JpPlan {
    public AspectDec aspectDec;
    public AdviceDec adviceDec;
    public JpPlan innerPlan;

    public AdviceDec getAdviceDec() {
        return this.adviceDec;
    }

    public AspectDec getAspectDec() {
        return this.aspectDec;
    }

    public AdvicePlan(JoinPoint jp, AspectDec aspectDec, AdviceDec adviceDec, JpPlan innerPlan) {
        super(jp);
        this.aspectDec = aspectDec;
        this.adviceDec = adviceDec;
        this.innerPlan = innerPlan;
        JpPlan other = innerPlan;
        this.test = this.simplify(other.test);
        this.ifTest = this.simplify(other.ifTest);
        this.instance = other.instance;
        this.bindings = other.bindings;
        this.dependencies = other.dependencies;
    }

    void checkExceptions(AdviceDec adviceDec, JoinPoint joinPoint) {
        TypeDs _throws = adviceDec.getThrows();
        if (_throws == null) {
            return;
        }
        int i = 0;
        while (i < _throws.size()) {
            Type t = _throws.get(i).getType();
            if (!joinPoint.canThrow(t)) {
                joinPoint.showError(adviceDec, "can't throw " + t.getPrettyString());
                break;
            }
            ++i;
        }
    }

    public void wrapJoinPoint(JoinPoint joinPoint) {
        this.checkExceptions(this.adviceDec, joinPoint);
        this.adviceDec.wrapJoinPoint(joinPoint, this);
    }

    public int compareTo(Object o) {
        int ret = super.compareTo(o);
        if (ret != 0) {
            return ret;
        }
        if (!(o instanceof AdvicePlan)) {
            return 0;
        }
        AdvicePlan otherPlan = (AdvicePlan)o;
        if (this.getAdviceDec().dominates(otherPlan.getAdviceDec())) {
            return -1;
        }
        if (otherPlan.getAdviceDec().dominates(this.getAdviceDec())) {
            return 1;
        }
        return 0;
    }

    public boolean matches(JpPlan other) {
        if (other instanceof AdvicePlan) {
            return this.getAdviceDec() == ((AdvicePlan)other).getAdviceDec();
        }
        return false;
    }

    public int getPreSortOrder() {
        if (this.adviceDec instanceof AroundAdviceDec) {
            return 1;
        }
        if (this.adviceDec instanceof BeforeAdviceDec) {
            return 1;
        }
        return 1;
    }

    public int fallbackCompareTo(Object o) {
        if (!(o instanceof AdvicePlan)) {
            return 0;
        }
        AdvicePlan otherPlan = (AdvicePlan)o;
        return this.getAspectDec().getId().compareTo(otherPlan.getAspectDec().getId());
    }

    public Exprs makeCallExprs(Expr extraExpr) {
        Expr instance = this.getInstance();
        Exprs exprs = this.getCallExprs(this.adviceDec.getFormals());
        Type type = this.adviceDec.getExtraArgType();
        if (type != null) {
            if (type.isEquivalent(this.getTypeManager().getObjectType())) {
                extraExpr = extraExpr.getType().makeObject(extraExpr);
            }
            if (!extraExpr.getType().isCoercableTo(type)) {
                return null;
            }
            extraExpr = this.getAST().makeCast(type, extraExpr);
            exprs.add(extraExpr);
        }
        if (this.adviceDec.needsStaticEnclosingJoinPointFormal()) {
            exprs.add(this.joinPoint.makeStaticEnclosingJoinPointVarExpr());
        }
        if (this.adviceDec.needsStaticJoinPointFormal()) {
            exprs.add(this.joinPoint.makeStaticJoinPointVarExpr());
        }
        if (this.adviceDec.needsDynamicJoinPointFormal()) {
            exprs.add(this.joinPoint.makeDynamicJoinPointVarExpr());
        }
        return exprs;
    }

    public Stmt makeCall(Expr extraExpr) {
        Exprs exprs = this.makeCallExprs(extraExpr);
        if (exprs == null) {
            return this.getAST().makeEmptyStmt();
        }
        Expr call = this.adviceDec.makeCall(this.instance, exprs);
        call.setSourceLocation(this.joinPoint.getTargetNode().getSourceLocation());
        Stmt callStmt = this.getAST().makeStmt(call);
        return this.wrapDynamicTest(callStmt);
    }

    public Expr getInstance() {
        if (this.instance == null) {
            return null;
        }
        return this.getAST().makeCast(this.getAspectDec().getType(), this.instance);
    }

    public String toString() {
        if (this.adviceDec == null || this.joinPoint == null) {
            return super.toString();
        }
        return "plan(" + this.joinPoint.toString() + ", " + this.adviceDec.toShortString() + ")";
    }
}

