/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Iterator;
import java.util.Set;
import org.aspectj.compiler.base.ExceptionFinder;
import org.aspectj.compiler.base.JavaCompiler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CatchClause;
import org.aspectj.compiler.base.ast.CatchClauses;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.NewInstanceExpr;
import org.aspectj.compiler.base.ast.PossibleSoftThrowable;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.TryCatchStmt;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlannerMaker;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;

public class SoftThrowableDec
extends Dec
implements JpPlannerMaker {
    protected GenTypeName genTypeName;
    protected Pcd pcd;

    public Modifiers getModifiers() {
        return this.getAST().makeModifiers(0);
    }

    public String getId() {
        return "declare";
    }

    public String toShortString() {
        return "declare soft: " + this.genTypeName.toShortString();
    }

    public String getKind() {
        return "declare soft";
    }

    public void checkSpec() {
        this.pcd.checkStatic();
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new WrappedJpPlanner(this.pcd.makePlanner(planData)){

            public JpPlan makePlan(JoinPoint jp) {
                JpPlan plan = super.makePlan(jp);
                if (jp.getSourceLocation() == null) {
                    return JpPlan.NO_PLAN;
                }
                if (!plan.isPossible()) {
                    return plan;
                }
                ASTObject target = jp.getTargetNode();
                if (target instanceof PossibleSoftThrowable) {
                    ((PossibleSoftThrowable)((Object)target)).setSoftThrowable();
                }
                return new SoftThrowablePlan(SoftThrowableDec.this.getCompiler(), plan);
            }

            public boolean isStaticPlanner() {
                return true;
            }
        };
    }

    CatchClause makeCatchClause(Type excType, JoinPoint jp) {
        AST ast = this.getAST();
        FormalDec formalDec = ast.makeFormal(excType, "exc");
        NewInstanceExpr softThrowable = ast.makeNew(this.getTypeManager().getType("org.aspectj.lang", "SoftException"), ast.makeVar(formalDec));
        BlockStmt softThrow = ast.makeBlock(ast.makeThrow(softThrowable));
        JpPlan plan = this.genTypeName.makePlan(jp, ast.makeVar(formalDec));
        Expr test = plan.getDynamicTest();
        BlockStmt body = test == null ? ast.makeBlock(softThrow) : ast.makeBlock(ast.makeIf(test, ast.makeBlock(softThrow), ast.makeBlock(ast.makeThrow(ast.makeVar(formalDec)))));
        return ast.makeCatch(formalDec, body);
    }

    Stmts wrapSoftThrowable(Stmts stmts, JoinPoint jp) {
        AST ast = this.getAST();
        CatchClauses clauses = new CatchClauses(ast.getSourceLocation());
        Set excTypes = ExceptionFinder.getPossibleExceptions(stmts, true);
        excTypes = Type.filterTopTypes(excTypes);
        Iterator i = excTypes.iterator();
        while (i.hasNext()) {
            Type excType = (Type)i.next();
            if (this.genTypeName.matchesInstance(excType).alwaysFalse()) continue;
            clauses.add(this.makeCatchClause(excType, jp));
        }
        return ast.makeStmts(new TryCatchStmt(ast.getSourceLocation(), ast.makeBlock(stmts), clauses));
    }

    public GenTypeName getGenTypeName() {
        return this.genTypeName;
    }

    public void setGenTypeName(GenTypeName _genTypeName) {
        if (_genTypeName != null) {
            _genTypeName.setParent(this);
        }
        this.genTypeName = _genTypeName;
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public SoftThrowableDec(SourceLocation location, GenTypeName _genTypeName, Pcd _pcd) {
        super(location);
        this.setGenTypeName(_genTypeName);
        this.setPcd(_pcd);
    }

    protected SoftThrowableDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        SoftThrowableDec ret = new SoftThrowableDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.genTypeName != null) {
            ret.setGenTypeName((GenTypeName)walker.process(this.genTypeName));
        }
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.genTypeName;
            }
            case 1: {
                return this.pcd;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "genTypeName";
            }
            case 1: {
                return "pcd";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setGenTypeName((GenTypeName)child);
                return;
            }
            case 1: {
                this.setPcd((Pcd)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "SoftThrowableDec()";
    }

    private class SoftThrowablePlan
    extends JpPlan {
        JpPlan innerPlan;

        public SoftThrowablePlan(JavaCompiler compiler, JpPlan innerPlan) {
            super(innerPlan.joinPoint);
            this.innerPlan = innerPlan;
        }

        public int getPreSortOrder() {
            return 0;
        }

        public String toString() {
            return "makesoft" + super.toString();
        }

        public void wrapJoinPoint(JoinPoint joinPoint) {
            joinPoint.setStmts(SoftThrowableDec.this.wrapSoftThrowable(joinPoint.getStmts(), joinPoint));
        }
    }
}

