/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Dec;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.StringLiteralExpr;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlannerMaker;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;

public class ShowErrorDec
extends Dec
implements JpPlannerMaker {
    protected Pcd pcd;
    protected Expr message;
    protected boolean isWarning;

    public Modifiers getModifiers() {
        return this.getAST().makeModifiers(0);
    }

    public String getId() {
        return "declare";
    }

    public String toShortString() {
        return this.getKind() + ": " + this.pcd.toShortString();
    }

    public String getKind() {
        return "declare " + (this.isWarning ? "warning" : "error");
    }

    public void checkSpec() {
        this.pcd.checkStatic();
        if (!(this.message instanceof StringLiteralExpr)) {
            this.message.showError("error message must be a constant string");
        }
    }

    public JpPlanner makePlanner(PlanData planData) {
        return new ErrorPlanner(this.getPcd().makePlanner(planData));
    }

    private String getMessageString() {
        if (!(this.message instanceof StringLiteralExpr)) {
            return "";
        }
        return ((StringLiteralExpr)this.message).getStringValue();
    }

    public void showErrorAt(JoinPoint point) {
        if (this.isWarning) {
            this.getCompiler().showWarning(point.getSourceLocation(), this.getMessageString());
        } else {
            this.getCompiler().showError(point.getSourceLocation(), this.getMessageString());
        }
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public Expr getMessage() {
        return this.message;
    }

    public void setMessage(Expr _message) {
        if (_message != null) {
            _message.setParent(this);
        }
        this.message = _message;
    }

    public boolean getIsWarning() {
        return this.isWarning;
    }

    public void setIsWarning(boolean _isWarning) {
        this.isWarning = _isWarning;
    }

    public ShowErrorDec(SourceLocation location, Pcd _pcd, Expr _message, boolean _isWarning) {
        super(location);
        this.setPcd(_pcd);
        this.setMessage(_message);
        this.setIsWarning(_isWarning);
    }

    protected ShowErrorDec(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ShowErrorDec ret = new ShowErrorDec(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        if (this.message != null) {
            ret.setMessage((Expr)walker.process(this.message));
        }
        ret.isWarning = this.isWarning;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.pcd;
            }
            case 1: {
                return this.message;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "pcd";
            }
            case 1: {
                return "message";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setPcd((Pcd)child);
                return;
            }
            case 1: {
                this.setMessage((Expr)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 2;
    }

    public String getDefaultDisplayName() {
        return "ShowErrorDec(isWarning: " + this.isWarning + ")";
    }

    private class ErrorPlanner
    extends WrappedJpPlanner {
        public ErrorPlanner(JpPlanner planner) {
            super(planner);
        }

        public JpPlan makePlan(JoinPoint jp) {
            if (jp.getSourceLocation() == null) {
                return JpPlan.NO_PLAN;
            }
            if (this.alwaysMatches(jp)) {
                ShowErrorDec.this.showErrorAt(jp);
            }
            return JpPlan.NO_PLAN;
        }

        public boolean isStaticPlanner() {
            return true;
        }
    }
}

