/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.FlowCheckerPass;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.Exprs;
import org.aspectj.compiler.base.ast.NameType;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.bcg.CodeBuilder;
import org.aspectj.compiler.crosscuts.ast.AroundAdviceDec;

public class ProceedExpr
extends Expr {
    protected Exprs args;
    protected AroundAdviceDec enclosingAround;

    protected Type discoverType() {
        return this.enclosingAround.getResultType();
    }

    public boolean isLegalStmt() {
        return true;
    }

    protected void cgValue(CodeBuilder cb) {
        this.getCompiler().internalError(this, "should no longer exist");
    }

    public Set getPossibleExceptions(boolean deFacto) {
        if (deFacto) {
            HashSet<NameType> set = new HashSet<NameType>();
            set.add(this.getTypeManager().getThrowableType());
            return set;
        }
        return Collections.EMPTY_SET;
    }

    public void walkFlow(FlowCheckerPass w) {
        w.process(this.getArgs());
        w.setExns(FlowCheckerPass.ESet.getEmpty().add(this.getTypeManager().getThrowableType()));
    }

    public Exprs getArgs() {
        return this.args;
    }

    public void setArgs(Exprs _args) {
        if (_args != null) {
            _args.setParent(this);
        }
        this.args = _args;
    }

    public AroundAdviceDec getEnclosingAround() {
        return this.enclosingAround;
    }

    public void setEnclosingAround(AroundAdviceDec _enclosingAround) {
        this.enclosingAround = _enclosingAround;
    }

    public ProceedExpr(SourceLocation location, Exprs _args, AroundAdviceDec _enclosingAround) {
        super(location);
        this.setArgs(_args);
        this.setEnclosingAround(_enclosingAround);
    }

    protected ProceedExpr(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        ProceedExpr ret = new ProceedExpr(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.args != null) {
            ret.setArgs((Exprs)walker.process(this.args));
        }
        ret.enclosingAround = this.enclosingAround;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.args;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "args";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setArgs((Exprs)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "ProceedExpr(enclosingAround: " + this.enclosingAround + ")";
    }
}

