/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.HashSet;
import java.util.Set;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.InterfaceDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class PerThisOrTarget
extends PerClause {
    private Set onTypes = new HashSet();
    private InterfaceDec hasAspectInterface;
    private MethodDec hasAspectBindMethod;
    private MethodDec hasAspectGetMethod;
    private MethodDec bindMethod;
    protected Pcd pcd;
    protected boolean onThis;

    public String toShortString() {
        return "per" + (this.onThis ? "this" : "target") + "(" + this.getPcd().toShortString() + ")";
    }

    public JpPlanner makeInnerPlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                Expr onExpr = PerThisOrTarget.this.makeOnExpr(jp);
                if (onExpr == null) {
                    return JpPlan.NO_PLAN;
                }
                JpPlan plan = new JpPlan(jp);
                plan.test = PerThisOrTarget.this.getHasAspectExpr(PerThisOrTarget.this.makeOnExpr(jp));
                plan.setInstanceExpr(PerThisOrTarget.this.getAspectOfExpr(PerThisOrTarget.this.makeOnExpr(jp)));
                return plan;
            }
        };
    }

    public JpPlanner makeInitializerPlanner(PlanData planData) {
        return new WrappedJpPlanner(this.getPcd().makePlanner(planData)){

            public JpPlan makePlan(JoinPoint jp) {
                Expr onExpr = PerThisOrTarget.this.makeOnExpr(jp);
                if (onExpr == null) {
                    return JpPlan.NO_PLAN;
                }
                if (PerThisOrTarget.this.getAspectType().isSubtypeOf(onExpr.getType())) {
                    PerThisOrTarget.this.getPcd().showWarning("will not match containing aspect (compiler limitation)");
                    return JpPlan.NO_PLAN;
                }
                JpPlan plan = super.makePlan(jp);
                if (plan.isPossible()) {
                    PerThisOrTarget.this.addHasAspectType(onExpr.getType(), jp);
                }
                return new InitializerPlan(plan);
            }
        };
    }

    void addHasAspectType(Type toType, JoinPoint jp) {
        if (this.onTypes.contains(toType)) {
            return;
        }
        if (toType == this.getHasAspectInterfaceType()) {
            return;
        }
        this.onTypes.add(toType);
        if (!toType.getTypeDec().fromSource()) {
            return;
        }
        toType.getTypeDec().addSuperInterfaceType(this.getHasAspectInterfaceType());
        toType.addDirectSuperType(this.getHasAspectInterfaceType());
    }

    public Expr makeOnExpr(JoinPoint point) {
        if (this.onThis) {
            return point.makeThisExpr();
        }
        return point.makeTargetExpr();
    }

    public Type getHasAspectInterfaceType() {
        return this.getHasAspectInterface().getType();
    }

    public InterfaceDec getHasAspectInterface() {
        if (this.hasAspectInterface != null) {
            return this.hasAspectInterface;
        }
        this.hasAspectInterface = this.makeHasAspectInterface();
        return this.hasAspectInterface;
    }

    String makeName(String base) {
        return this.getAST().makeGeneratedName(this.getAspectType().getString() + "_" + base);
    }

    int getFieldModifiers() {
        if (this.getOptions().XserializableAspects && this.getAspectType().isSubtypeOf(this.getTypeManager().getSerializableType())) {
            return 2;
        }
        return 130;
    }

    InterfaceDec makeHasAspectInterface() {
        AST ast = this.getAST();
        this.hasAspectInterface = ast.makeInterface(ast.makeModifiers(1), "AJC_HasAspect", ast.makeTypeDs());
        this.hasAspectInterface.setEnclosingTypeDec(this.getAspectDec());
        this.getAspectDec().addToBody(this.hasAspectInterface);
        FieldDec aspectField = ast.makeField(ast.makeModifiers(this.getFieldModifiers()), this.getAspectType(), this.makeName("_aspect"));
        this.hasAspectInterface.getBody().add(aspectField);
        this.hasAspectBindMethod = ast.makeMethod(ast.makeModifiers(34), this.getTypeManager().voidType, this.makeName("bind"), ast.makeFormals(), ast.makeBlock(ast.makeIf(ast.makeNonNullTest(ast.makeGet(aspectField.getField())), ast.makeReturn()), ast.makeSet(aspectField.getField(), (Expr)ast.makeNew(this.getAspectType()))));
        this.hasAspectInterface.getBody().add(this.hasAspectBindMethod);
        this.hasAspectGetMethod = ast.makeMethod(ast.makeModifiers(2), this.getAspectType(), this.makeName("getAspect"), ast.makeFormals(), ast.makeBlock(ast.makeReturn(ast.makeGet(aspectField.getField()))));
        this.hasAspectInterface.getBody().add(this.hasAspectGetMethod);
        return this.hasAspectInterface;
    }

    MethodDec getBindMethod() {
        if (this.bindMethod != null) {
            return this.bindMethod;
        }
        AST ast = this.getAST();
        FormalDec objFormal = ast.makeFormal(this.getTypeManager().getObjectType(), "obj");
        this.bindMethod = ast.makeMethod(ast.makeModifiers(41), this.getTypeManager().voidType, "bind$ajc", ast.makeFormals(objFormal), ast.makeBlock(ast.makeIf(ast.makeNotInstanceofTest(ast.makeVar(objFormal), this.getHasAspectInterfaceType()), ast.makeReturn()), ast.makeCall(this.hasAspectBindMethod, ast.makeCast(this.getHasAspectInterfaceType(), ast.makeVar(objFormal)))));
        this.getAspectDec().addToBody(this.bindMethod);
        return this.bindMethod;
    }

    protected MethodDec makeHasAspectMethod() {
        AST ast = this.getAST();
        FormalDec objFormal = ast.makeFormal(this.getTypeManager().getObjectType(), "obj");
        BlockStmt body = ast.makeBlock(ast.makeIf(ast.makeNotInstanceofTest(ast.makeVar(objFormal), this.getHasAspectInterfaceType()), ast.makeReturn(ast.makeLiteral(false))), ast.makeReturn(ast.makeNonNullTest(ast.makeCall(this.hasAspectGetMethod, ast.makeCast(this.getHasAspectInterfaceType(), ast.makeVar(objFormal))))));
        return this.makeHasAspectMethod(ast.makeFormals(objFormal), body);
    }

    protected MethodDec makeAspectOfMethod() {
        this.getHasAspectInterfaceType();
        AST ast = this.getAST();
        VarDec aspDec = ast.makeVarDec(this.getAspectType(), "asp", ast.makeNull());
        FormalDec objFormal = ast.makeFormal(this.getTypeManager().getObjectType(), "obj");
        BlockStmt body = ast.makeBlock(aspDec, ast.makeIf(ast.makeInstanceof(ast.makeVar(objFormal), this.getHasAspectInterfaceType()), ast.makeBlock(ast.makeSet(aspDec, (Expr)ast.makeCall(this.hasAspectGetMethod, ast.makeCast(this.getHasAspectInterfaceType(), ast.makeVar(objFormal)))))), ast.makeIf(ast.makeNullTest(ast.makeVar(aspDec)), ast.makeBlock(ast.makeThrow(ast.makeNew(this.getTypeManager().getType("org.aspectj.lang", "NoAspectBoundException"))))), ast.makeReturn(ast.makeVar(aspDec)));
        return this.makeAspectOfMethod(ast.makeFormals(objFormal), body);
    }

    Expr bindExpr(Expr onExpr) {
        return this.getAST().makeStaticCall(this.getBindMethod(), onExpr);
    }

    Expr getHasAspectExpr(Expr onExpr) {
        AST ast = this.getAST();
        return ast.makeStaticCall(this.hasAspectMethod, onExpr);
    }

    Expr getAspectOfExpr(Expr onExpr) {
        AST ast = this.getAST();
        return ast.makeParen(ast.forceCast(this.getAspectType(), ast.makeStaticCall(this.aspectOfMethod, onExpr)));
    }

    public Stmts wrapCheckAndSet(JpPlan plan, JoinPoint jp, Stmts body) {
        AST ast = this.getAST();
        Expr onExpr = this.makeOnExpr(jp);
        if (onExpr == null) {
            return body;
        }
        Stmt stmt = ast.makeStmt(this.bindExpr(onExpr));
        stmt = plan.wrapDynamicTest(ast.makeBlock(stmt));
        body.add(0, stmt);
        return body;
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public boolean getOnThis() {
        return this.onThis;
    }

    public void setOnThis(boolean _onThis) {
        this.onThis = _onThis;
    }

    public PerThisOrTarget(SourceLocation location, Pcd _pcd, boolean _onThis) {
        super(location);
        this.setPcd(_pcd);
        this.setOnThis(_onThis);
    }

    protected PerThisOrTarget(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PerThisOrTarget ret = new PerThisOrTarget(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        ret.onThis = this.onThis;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.pcd;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "pcd";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setPcd((Pcd)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "PerThisOrTarget(onThis: " + this.onThis + ")";
    }

    private class InitializerPlan
    extends JpPlan {
        JpPlan innerPlan;

        public InitializerPlan(JpPlan innerPlan) {
            super(innerPlan.joinPoint);
            this.innerPlan = innerPlan;
        }

        public int getPreSortOrder() {
            return 0;
        }

        public String toString() {
            return "perobject" + super.toString();
        }

        public void wrapJoinPoint(JoinPoint jp) {
            jp.setStmts(this.wrapCheckAndSet(jp, jp.getStmts()));
        }

        public Stmts wrapCheckAndSet(JoinPoint jp, Stmts stmts) {
            return PerThisOrTarget.this.wrapCheckAndSet(this.innerPlan, jp, stmts);
        }
    }
}

