/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.BlockStmt;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FieldDec;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.MethodDec;
import org.aspectj.compiler.base.ast.Modifiers;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Stmt;
import org.aspectj.compiler.base.ast.Stmts;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.ast.VarDec;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PerClause;
import org.aspectj.compiler.crosscuts.ast.PlanData;
import org.aspectj.compiler.crosscuts.joinpoints.EachObjectPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlanner;
import org.aspectj.compiler.crosscuts.joinpoints.WrappedJpPlanner;
import org.aspectj.util.FuzzyBoolean;

public class PerObject
extends PerClause {
    private FieldDec map;
    private MethodDec bindMethod;
    protected Pcd pcd;
    protected boolean onThis;

    public String toShortString() {
        return "per" + (this.onThis ? "this" : "target") + "(" + this.getPcd().toShortString() + ")";
    }

    public JpPlanner makeInnerPlanner(PlanData planData) {
        return new JpPlanner(){

            public FuzzyBoolean fastMatch(JoinPoint jp) {
                return FuzzyBoolean.MAYBE;
            }

            public JpPlan makePlan(JoinPoint jp) {
                Expr onExpr = PerObject.this.makeOnExpr(jp);
                if (onExpr == null) {
                    return JpPlan.NO_PLAN;
                }
                JpPlan plan = new JpPlan(jp);
                plan.test = PerObject.this.testMapExpr(PerObject.this.makeOnExpr(jp));
                plan.setInstanceExpr(PerObject.this.getAspectOfExpr(PerObject.this.makeOnExpr(jp)));
                return plan;
            }
        };
    }

    public JpPlanner makeInitializerPlanner(PlanData planData) {
        return new WrappedJpPlanner(this.getPcd().makePlanner(planData)){

            public JpPlan makePlan(JoinPoint jp) {
                if (PerObject.this.makeOnExpr(jp) == null) {
                    return JpPlan.NO_PLAN;
                }
                JpPlan plan = super.makePlan(jp);
                return new EachObjectPlan(plan, PerObject.this);
            }
        };
    }

    public Expr makeOnExpr(JoinPoint point) {
        if (this.onThis) {
            return point.makeThisExpr();
        }
        return point.makeTargetExpr();
    }

    FieldDec getMapField() {
        if (this.map != null) {
            return this.map;
        }
        AST ast = this.getAST();
        String name = "permap$ajc";
        Type type = this.getTypeManager().getType("org.aspectj.runtime.internal", "PerObjectMap");
        Modifiers modifiers = ast.makeModifiers(25);
        this.map = ast.makeField(modifiers, type, name, ast.makeNew(type));
        this.getAspectDec().addToBody(this.map);
        return this.map;
    }

    MethodDec getBindMethod() {
        if (this.bindMethod != null) {
            return this.bindMethod;
        }
        AST ast = this.getAST();
        FormalDec toObjectFormal = ast.makeFormal(this.getTypeManager().getObjectType(), "toObject");
        BlockStmt body = ast.makeBlock(ast.makeIf(ast.makeUnop("!", this.testMapExpr(ast.makeVar(toObjectFormal))), ast.makeBlock(ast.makeCall(this.getMapVar(), "bind", (Expr)ast.makeVar(toObjectFormal), (Expr)ast.makeNew(this.getAspectType())))));
        Modifiers modifiers = ast.makeModifiers(41);
        this.bindMethod = ast.makeMethod(modifiers, this.getTypeManager().voidType, "bind$ajc", ast.makeFormals(toObjectFormal), body);
        this.getAspectDec().addToBody(this.bindMethod);
        return this.bindMethod;
    }

    Expr getMapVar() {
        return this.getAST().makeGet(this.getMapField());
    }

    Expr testMapExpr(Expr onExpr) {
        return this.getAST().makeCall(this.getMapVar(), "hasAspect", onExpr);
    }

    Expr bindExpr(Expr onExpr) {
        return this.getAST().makeStaticCall(this.getBindMethod(), onExpr);
    }

    Expr getAspectOfExpr(Expr onExpr) {
        AST ast = this.getAST();
        return ast.makeParen(ast.forceCast(this.getAspectType(), ast.makeCall(this.getMapVar(), "aspectOf", onExpr)));
    }

    protected MethodDec makeHasAspectMethod() {
        AST ast = this.getAST();
        FormalDec onObjectFormal = ast.makeFormal(this.getTypeManager().getObjectType(), "onObject");
        BlockStmt body = ast.makeBlock(ast.makeReturn(this.testMapExpr(ast.makeVar(onObjectFormal))));
        return this.makeHasAspectMethod(ast.makeFormals(onObjectFormal), body);
    }

    protected MethodDec makeAspectOfMethod() {
        AST ast = this.getAST();
        FormalDec onObjectFormal = ast.makeFormal(this.getTypeManager().getObjectType(), "onObject");
        VarDec aspectDec = ast.makeVarDec(this.getAspectType(), "asp", this.getAspectOfExpr(ast.makeVar(onObjectFormal)));
        BlockStmt body = ast.makeBlock(aspectDec, ast.makeIf(ast.makeNonNullTest(ast.makeVar(aspectDec)), ast.makeReturn(ast.makeVar(aspectDec))), ast.makeThrow(this.getTypeManager().getType("org.aspectj.lang", "NoAspectBoundException")));
        return this.makeAspectOfMethod(ast.makeFormals(onObjectFormal), body);
    }

    public Stmts wrapCheckAndSet(JpPlan plan, JoinPoint jp, Stmts body) {
        AST ast = this.getAST();
        Expr onExpr = this.makeOnExpr(jp);
        if (onExpr == null) {
            return body;
        }
        Stmt stmt = ast.makeStmt(this.bindExpr(onExpr));
        stmt = plan.wrapDynamicTest(ast.makeBlock(stmt));
        body.add(0, stmt);
        return body;
    }

    public Pcd getPcd() {
        return this.pcd;
    }

    public void setPcd(Pcd _pcd) {
        if (_pcd != null) {
            _pcd.setParent(this);
        }
        this.pcd = _pcd;
    }

    public boolean getOnThis() {
        return this.onThis;
    }

    public void setOnThis(boolean _onThis) {
        this.onThis = _onThis;
    }

    public PerObject(SourceLocation location, Pcd _pcd, boolean _onThis) {
        super(location);
        this.setPcd(_pcd);
        this.setOnThis(_onThis);
    }

    protected PerObject(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PerObject ret = new PerObject(this.getSourceLocation());
        ret.preCopy(walker, this);
        if (this.pcd != null) {
            ret.setPcd((Pcd)walker.process(this.pcd));
        }
        ret.onThis = this.onThis;
        return ret;
    }

    public ASTObject getChildAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return this.pcd;
            }
        }
        return super.getChildAt(childIndex);
    }

    public String getChildNameAt(int childIndex) {
        switch (childIndex) {
            case 0: {
                return "pcd";
            }
        }
        return super.getChildNameAt(childIndex);
    }

    public void setChildAt(int childIndex, ASTObject child) {
        switch (childIndex) {
            case 0: {
                this.setPcd((Pcd)child);
                return;
            }
        }
        super.setChildAt(childIndex, child);
    }

    public int getChildCount() {
        return 1;
    }

    public String getDefaultDisplayName() {
        return "PerObject(onThis: " + this.onThis + ")";
    }
}

