/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.compiler.crosscuts.ast;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.aspectj.compiler.base.ErrorHandler;
import org.aspectj.compiler.base.ast.AST;
import org.aspectj.compiler.base.ast.ASTObject;
import org.aspectj.compiler.base.ast.CopyWalker;
import org.aspectj.compiler.base.ast.Expr;
import org.aspectj.compiler.base.ast.FormalDec;
import org.aspectj.compiler.base.ast.Formals;
import org.aspectj.compiler.base.ast.ScopeWalker;
import org.aspectj.compiler.base.ast.SourceLocation;
import org.aspectj.compiler.base.ast.Type;
import org.aspectj.compiler.base.cst.Name;
import org.aspectj.compiler.base.cst.Scope;
import org.aspectj.compiler.crosscuts.ast.AdviceDec;
import org.aspectj.compiler.crosscuts.ast.AnyTypeName;
import org.aspectj.compiler.crosscuts.ast.EllipsesFakeNamePattern;
import org.aspectj.compiler.crosscuts.ast.GenTypeName;
import org.aspectj.compiler.crosscuts.ast.NamePattern;
import org.aspectj.compiler.crosscuts.ast.NamePatterns;
import org.aspectj.compiler.crosscuts.ast.Pcd;
import org.aspectj.compiler.crosscuts.ast.PointcutDec;
import org.aspectj.compiler.crosscuts.ast.SimpleTypeName;
import org.aspectj.compiler.crosscuts.ast.VarTypeName;
import org.aspectj.compiler.crosscuts.joinpoints.JoinPoint;
import org.aspectj.compiler.crosscuts.joinpoints.JpPlan;
import org.aspectj.util.FuzzyBoolean;

public class PatternTypeName
extends GenTypeName {
    Map matchCache = new HashMap();
    Map instanceMatchCache = new HashMap();
    private Scope savedScope;
    protected NamePatterns names;
    protected boolean includeSubTypes;
    protected int dimensions;

    public String toShortString() {
        String ret = this.names.toShortString();
        if (this.includeSubTypes) {
            ret = ret + "+";
        }
        return ret;
    }

    private Formals getEnclosingFormals(ASTObject node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Formals) {
            return (Formals)node;
        }
        if (node instanceof AdviceDec) {
            return ((AdviceDec)node).getFormals();
        }
        if (node instanceof PointcutDec) {
            return ((PointcutDec)node).getFormals();
        }
        return this.getEnclosingFormals(node.getParent());
    }

    private FormalDec getEnclosingAfterFormal(ASTObject node) {
        if (node == null) {
            return null;
        }
        if (node instanceof AdviceDec) {
            return ((AdviceDec)node).getExtraFormal();
        }
        return this.getEnclosingAfterFormal(node.getParent());
    }

    private Pcd getEnclosingPcd(ASTObject node) {
        if (node == null) {
            return null;
        }
        if (node instanceof Pcd) {
            return (Pcd)node;
        }
        return this.getEnclosingPcd(node.getParent());
    }

    public ASTObject postScope(ScopeWalker walker) {
        Type primType;
        String id;
        if (this.savedScope != null) {
            return this;
        }
        this.savedScope = walker.getScope();
        if (this.names.size() == 1 && this.names.get(0).isStar() && this.dimensions == 0) {
            return new AnyTypeName(this.getSourceLocation()).setSource(this);
        }
        if (this.names.size() == 1 && this.dimensions == 0) {
            Formals formals = this.getEnclosingFormals(this);
            String id2 = this.names.get(0).getSimpleName();
            if (formals != null) {
                FormalDec formalDec = formals.findName(id2);
                if (formalDec != null) {
                    return this.makeVarTypeName(formalDec);
                }
                FormalDec afterFormal = this.getEnclosingAfterFormal(this);
                if (afterFormal != null && afterFormal.getId().equals(id2)) {
                    this.getCompiler().showError(this, "can't refer to '" + afterFormal.toShortString() + "' from this context");
                    return this.makeSimpleTypeName(this.getTypeManager().TYPE_NOT_FOUND);
                }
            }
        }
        if (this.names.size() == 1 && (id = this.names.get(0).getSimpleName()) != null && (primType = this.getTypeManager().findPrimitiveType(id)) != null) {
            return this.makeSimpleTypeName(primType);
        }
        return this;
    }

    private SimpleTypeName makeSimpleTypeName(Type t) {
        int i = 0;
        while (i < this.dimensions) {
            t = t.getArrayType();
            ++i;
        }
        return new SimpleTypeName(this.getSourceLocation(), t, this.includeSubTypes);
    }

    private boolean anyTypeMatches() {
        Iterator i = this.getTypeManager().getLoadedTypes().iterator();
        while (i.hasNext()) {
            Type t = (Type)i.next();
            if (!this.matches(t.getNamePieces())) continue;
            return true;
        }
        Iterator i2 = this.getTypeManager().getAllVisibleTypeNames().iterator();
        while (i2.hasNext()) {
            List pieces = (List)i2.next();
            if (!this.matches(pieces)) continue;
            return true;
        }
        return false;
    }

    public void checkSpec() {
        Name cstName = this.names.makeName();
        if (cstName != null) {
            cstName.setParent(this);
            Type t = cstName.resolveType(this.savedScope, false);
            if (t.isMissing()) {
                this.getCompiler().showWarning((ASTObject)this, ErrorHandler.invalidAbsoluteTypeName);
                super.checkSpec();
                return;
            }
            SimpleTypeName s = this.makeSimpleTypeName(t);
            this.replaceWith(s);
            s.checkSpec();
            return;
        }
        if (ErrorHandler.invalidWildcardTypeName.shouldDisplay(this.getCompiler()) && !this.anyTypeMatches()) {
            this.getCompiler().showWarning((ASTObject)this, ErrorHandler.invalidWildcardTypeName);
        }
        super.checkSpec();
    }

    protected GenTypeName makeVarTypeName(FormalDec formalDec) {
        formalDec.isBound = true;
        if (this.includeSubTypes || this.getParent() instanceof GenTypeName) {
            this.showError("formal binding can not be done as part of a GTN");
            return this;
        }
        if (!this.getEnclosingPcd(this).allowsNameBinding()) {
            this.showError("name binding is only allowed in target, this, and args PCDs");
            return this;
        }
        return new VarTypeName(this.getSourceLocation(), formalDec);
    }

    public ASTObject postCopy(CopyWalker walker, ASTObject oldObject) {
        this.savedScope = ((PatternTypeName)oldObject).savedScope;
        return this;
    }

    public FuzzyBoolean matchesInstance(Type type) {
        FuzzyBoolean ret = (FuzzyBoolean)this.instanceMatchCache.get(type);
        if (ret != null) {
            return ret;
        }
        HashSet tests = new HashSet();
        boolean isMatch = this.matches(null, type, false, tests);
        ret = !isMatch ? FuzzyBoolean.NO : (tests.size() == 0 ? FuzzyBoolean.YES : FuzzyBoolean.MAYBE);
        this.instanceMatchCache.put(type, ret);
        return ret;
    }

    void addInstanceTests(Set instanceTests, Expr expr, JpPlan plan) {
        if (instanceTests.size() == 0) {
            return;
        }
        instanceTests = Type.filterTopTypes(instanceTests);
        Expr testExpr = null;
        AST ast = this.getAST();
        Iterator i = instanceTests.iterator();
        while (i.hasNext()) {
            Type matchingType = (Type)i.next();
            if (expr.getType().isSubtypeOf(matchingType)) continue;
            Expr instanceTest = ast.makeParen(ast.makeInstanceof(expr, matchingType));
            testExpr = testExpr == null ? instanceTest : ast.makeBinop("||", testExpr, instanceTest);
        }
        if (testExpr != null) {
            plan.addExprTest(testExpr);
        }
    }

    public JpPlan makePlan(JoinPoint jp, Expr expr) {
        JpPlan plan = new JpPlan(jp);
        if (expr.getType() == null) {
            return JpPlan.NO_PLAN;
        }
        HashSet instanceTests = new HashSet();
        if (this.matches(plan, expr.getType(), false, instanceTests)) {
            this.addInstanceTests(instanceTests, expr, plan);
            return plan;
        }
        return JpPlan.NO_PLAN;
    }

    boolean matches(JpPlan plan, Type asType, boolean needsTest, Set instanceofTests) {
        Type matchingType = this.matches(asType, true);
        if (matchingType != null) {
            if (needsTest) {
                instanceofTests.add(matchingType);
            }
            return true;
        }
        boolean couldMatch = false;
        Collection subTypes = asType.getDirectSubTypes();
        if (subTypes == null) {
            return false;
        }
        Iterator i = subTypes.iterator();
        while (i.hasNext()) {
            if (!this.matches(plan, (Type)i.next(), true, instanceofTests)) continue;
            couldMatch = true;
        }
        return couldMatch;
    }

    public boolean matches(Type type) {
        return this.matches(type, this.includeSubTypes) != null;
    }

    public Type matches(Type type, boolean includeSubTypes) {
        if (this.basicMatch(type)) {
            return type;
        }
        if (includeSubTypes) {
            Iterator i = type.getDirectSuperTypes().iterator();
            while (i.hasNext()) {
                Type tryType = (Type)i.next();
                Type matchType = this.matches(tryType, includeSubTypes);
                if (matchType == null) continue;
                return matchType;
            }
        }
        return null;
    }

    protected boolean basicMatch(Type type) {
        Boolean cachedResult = (Boolean)this.matchCache.get(type);
        if (cachedResult != null) {
            return cachedResult;
        }
        boolean ret = this.innerBasicMatch(type);
        this.matchCache.put(type, ret ? Boolean.TRUE : Boolean.FALSE);
        return ret;
    }

    private boolean innerBasicMatch(Type type) {
        List pieces;
        if (this.dimensions != type.getArrayDimCount()) {
            if (this.dimensions == 0) {
                type = this.getTypeManager().getObjectType();
            } else {
                return false;
            }
        }
        return this.matches(pieces = type.getBaseComponentType().getNamePieces());
    }

    private boolean isEllipses(NamePattern name) {
        return name instanceof EllipsesFakeNamePattern;
    }

    protected boolean matches(List pieces) {
        return this.matches(pieces, pieces.size() - 1, this.names.size() - 1);
    }

    protected boolean matches(List pieces, int pieceIndex, int nameIndex) {
        if (nameIndex < 0) {
            Type importType;
            if (++pieceIndex == 0) {
                return true;
            }
            if (this.savedScope == null) {
                this.showError("no saved scope");
            }
            if ((importType = this.savedScope.findType((String)pieces.get(pieceIndex), this)) == null) {
                return false;
            }
            List importPieces = importType.getNamePieces();
            return importPieces.equals(pieces.subList(0, pieceIndex + 1));
        }
        if (pieceIndex < 0) {
            return false;
        }
        NamePattern name = this.names.get(nameIndex);
        if (this.isEllipses(name)) {
            while (pieceIndex >= 0) {
                if (this.matches(pieces, pieceIndex, nameIndex - 1)) {
                    return true;
                }
                --pieceIndex;
            }
            return false;
        }
        if (name.matches((String)pieces.get(pieceIndex))) {
            return this.matches(pieces, pieceIndex - 1, nameIndex - 1);
        }
        return false;
    }

    public NamePatterns getNames() {
        return this.names;
    }

    public void setNames(NamePatterns _names) {
        this.names = _names;
    }

    public boolean getIncludeSubTypes() {
        return this.includeSubTypes;
    }

    public void setIncludeSubTypes(boolean _includeSubTypes) {
        this.includeSubTypes = _includeSubTypes;
    }

    public int getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(int _dimensions) {
        this.dimensions = _dimensions;
    }

    public PatternTypeName(SourceLocation location, NamePatterns _names, boolean _includeSubTypes, int _dimensions) {
        super(location);
        this.setNames(_names);
        this.setIncludeSubTypes(_includeSubTypes);
        this.setDimensions(_dimensions);
    }

    protected PatternTypeName(SourceLocation source) {
        super(source);
    }

    public ASTObject copyWalk(CopyWalker walker) {
        PatternTypeName ret = new PatternTypeName(this.getSourceLocation());
        ret.preCopy(walker, this);
        ret.names = this.names;
        ret.includeSubTypes = this.includeSubTypes;
        ret.dimensions = this.dimensions;
        return ret;
    }

    public String getDefaultDisplayName() {
        return "PatternTypeName(names: " + this.names + ", " + "includeSubTypes: " + this.includeSubTypes + ", " + "dimensions: " + this.dimensions + ")";
    }
}

